/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.mixin;

import java.util.Random;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.structure.StructureManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import someoneelse.betternetherreforged.world.BNWorldGenerator;

@Mixin(value={ChunkGenerator.class})
public abstract class ChunkGeneratorMixin {
    private static final SharedSeedRandom RANDOM = new SharedSeedRandom();
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    @Inject(method={"func_230351_a_"}, at={@At(value="HEAD")}, cancellable=true)
    private void customPopulate(WorldGenRegion region, StructureManager accessor, CallbackInfo info) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        if (!region.func_201670_d() && this.isNetherBiome(region, chunkX, chunkZ)) {
            RANDOM.func_202422_a(chunkX, chunkZ);
            int sx = chunkX << 4;
            int sz = chunkZ << 4;
            BNWorldGenerator.prePopulate(region, sx, sz, (Random)RANDOM);
            long featureSeed = RANDOM.func_202424_a(region.func_72905_C(), chunkX, chunkZ);
            ChunkGenerator generator = (ChunkGenerator)this;
            for (Biome biome : BNWorldGenerator.getPopulateBiomes()) {
                try {
                    biome.func_242427_a(accessor, generator, region, featureSeed, RANDOM, new BlockPos(sx, 0, sz));
                }
                catch (Exception e) {
                    CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Biome decoration");
                    crashReport.func_85058_a("Generation").func_71507_a("CenterX", (Object)region.func_201679_a()).func_71507_a("CenterZ", (Object)region.func_201680_b()).func_71507_a("Seed", (Object)featureSeed).func_71507_a("Biome", (Object)biome);
                    throw new ReportedException(crashReport);
                }
            }
            BNWorldGenerator.populate(region, sx, sz, (Random)RANDOM);
            BNWorldGenerator.cleaningPass((IWorld)region, sx, sz);
            info.cancel();
        }
    }

    private boolean isNetherBiome(WorldGenRegion world, int cx, int cz) {
        POS.func_181079_c(cx << 4, 0, cx << 4);
        return this.isNetherBiome(world.func_226691_t_((BlockPos)POS)) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(0, 0, 7))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(0, 0, 15))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(7, 0, 0))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(7, 0, 7))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(7, 0, 15))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(15, 0, 0))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(15, 0, 7))) || this.isNetherBiome(world.func_226691_t_(POS.func_177982_a(15, 0, 15)));
    }

    private boolean isNetherBiome(Biome biome) {
        return biome.func_201856_r() == Biome.Category.NETHER;
    }
}

