/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;

public class BlockPlantWall
extends BlockBaseNotFull {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)BlockPlantWall.func_208617_a((double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0, (double)16.0), (Object)Direction.SOUTH, (Object)BlockPlantWall.func_208617_a((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)6.0), (Object)Direction.WEST, (Object)BlockPlantWall.func_208617_a((double)10.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (Object)Direction.EAST, (Object)BlockPlantWall.func_208617_a((double)0.0, (double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0)));
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public BlockPlantWall(MaterialColor color) {
        super(MaterialBuilder.makeGrass(color));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader view, BlockPos pos) {
        return 1.0f;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{FACING});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        return BOUNDING_SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockPos blockPos = pos.func_177972_a(direction.func_176734_d());
        BlockState blockState = world.func_180495_p(blockPos);
        return blockState.func_224755_d((IBlockReader)world, blockPos, direction);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        if (this.func_196260_a(state, (IWorldReader)world, pos)) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        return BlocksHelper.rotateHorizontal(state, rotation, (Property<Direction>)FACING);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return BlocksHelper.mirrorHorizontal(state, mirror, (Property<Direction>)FACING);
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = this.func_176223_P();
        World IWorldReader2 = ctx.func_195991_k();
        BlockPos blockPos = ctx.func_195995_a();
        Direction[] directions = ctx.func_196009_e();
        for (int i = 0; i < directions.length; ++i) {
            Direction direction2;
            Direction direction = directions[i];
            if (!direction.func_176740_k().func_176722_c() || !(blockState = (BlockState)blockState.func_206870_a((Property)FACING, (Comparable)(direction2 = direction.func_176734_d()))).func_196955_c((IWorldReader)IWorldReader2, blockPos)) continue;
            return blockState;
        }
        return null;
    }
}

