/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.blocks.BNRenderLayer;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlockMushroomFir
extends BlockBaseNotFull {
    public static final EnumProperty<MushroomFirShape> SHAPE = EnumProperty.func_177709_a((String)"shape", MushroomFirShape.class);
    private static final VoxelShape BOTTOM_SHAPE = BlockMushroomFir.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockMushroomFir.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TOP_SHAPE = BlockMushroomFir.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SIDE_BIG_SHAPE = BlockMushroomFir.func_208617_a((double)0.01, (double)0.01, (double)0.01, (double)15.99, (double)13.0, (double)15.99);
    private static final VoxelShape SIDE_SMALL_N_SHAPE = BlockMushroomFir.func_208617_a((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)8.0, (double)8.0);
    private static final VoxelShape SIDE_SMALL_S_SHAPE = BlockMushroomFir.func_208617_a((double)4.0, (double)1.0, (double)8.0, (double)12.0, (double)8.0, (double)16.0);
    private static final VoxelShape SIDE_SMALL_E_SHAPE = BlockMushroomFir.func_208617_a((double)8.0, (double)1.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0);
    private static final VoxelShape SIDE_SMALL_W_SHAPE = BlockMushroomFir.func_208617_a((double)0.0, (double)1.0, (double)4.0, (double)8.0, (double)8.0, (double)12.0);
    private static final VoxelShape END_SHAPE = BlockMushroomFir.func_208617_a((double)0.01, (double)0.0, (double)0.01, (double)15.99, (double)15.99, (double)15.99);

    public BlockMushroomFir() {
        super(MaterialBuilder.makeWood(MaterialColor.field_151679_y).func_200947_a(SoundType.field_235580_B_).func_226896_b_());
        this.setDropItself(false);
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        switch ((MushroomFirShape)((Object)state.func_177229_b(SHAPE))) {
            case BOTTOM: {
                return BOTTOM_SHAPE;
            }
            case END: {
                return END_SHAPE;
            }
            default: {
                return MIDDLE_SHAPE;
            }
            case SIDE_BIG_E: 
            case SIDE_BIG_N: 
            case SIDE_BIG_S: 
            case SIDE_BIG_W: {
                return SIDE_BIG_SHAPE;
            }
            case SIDE_SMALL_E: {
                return SIDE_SMALL_E_SHAPE;
            }
            case SIDE_SMALL_N: {
                return SIDE_SMALL_N_SHAPE;
            }
            case SIDE_SMALL_S: {
                return SIDE_SMALL_S_SHAPE;
            }
            case SIDE_SMALL_W: {
                return SIDE_SMALL_W_SHAPE;
            }
            case TOP: 
        }
        return TOP_SHAPE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        MushroomFirShape shape = (MushroomFirShape)((Object)state.func_177229_b(SHAPE));
        return shape == MushroomFirShape.BOTTOM || shape == MushroomFirShape.MIDDLE ? new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_FIR_STEM) : new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_FIR_SAPLING);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        MushroomFirShape shape = (MushroomFirShape)((Object)state.func_177229_b(SHAPE));
        if (shape == MushroomFirShape.SIDE_BIG_N || shape == MushroomFirShape.SIDE_SMALL_N) {
            return world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_S || shape == MushroomFirShape.SIDE_SMALL_S) {
            return world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_E || shape == MushroomFirShape.SIDE_SMALL_E) {
            return world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        }
        if (shape == MushroomFirShape.SIDE_BIG_W || shape == MushroomFirShape.SIDE_SMALL_W) {
            return world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        }
        BlockState down = world.func_180495_p(pos.func_177977_b());
        return down.func_177230_c() == this || down.func_224755_d((IBlockReader)world, pos.func_177977_b(), Direction.UP);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        return this.func_196260_a(state, (IWorldReader)world, pos) ? state : Blocks.field_150350_a.func_176223_P();
    }

    public static enum MushroomFirShape implements IStringSerializable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top"),
        SIDE_BIG_N("side_big_n"),
        SIDE_BIG_S("side_big_s"),
        SIDE_BIG_E("side_big_e"),
        SIDE_BIG_W("side_big_w"),
        SIDE_SMALL_N("side_small_n"),
        SIDE_SMALL_S("side_small_s"),
        SIDE_SMALL_E("side_small_e"),
        SIDE_SMALL_W("side_small_w"),
        END("end");

        final String name;

        private MushroomFirShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

