/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import someoneelse.betternetherreforged.blocks.BlockBaseNotFull;
import someoneelse.betternetherreforged.blocks.materials.MaterialBuilder;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlockBrownLargeMushroom
extends BlockBaseNotFull {
    private static final VoxelShape TOP_CENTER_SHAPE = BlockBrownLargeMushroom.func_208617_a((double)0.0, (double)0.1, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_EDGE_SHAPE = BlockBrownLargeMushroom.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = BlockBrownLargeMushroom.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final EnumProperty<BrownMushroomShape> SHAPE = EnumProperty.func_177709_a((String)"shape", BrownMushroomShape.class);
    private static final BrownMushroomShape[] ROT_SIDE = new BrownMushroomShape[]{BrownMushroomShape.SIDE_N, BrownMushroomShape.SIDE_E, BrownMushroomShape.SIDE_S, BrownMushroomShape.SIDE_W};
    private static final BrownMushroomShape[] ROT_CORNER = new BrownMushroomShape[]{BrownMushroomShape.CORNER_N, BrownMushroomShape.CORNER_E, BrownMushroomShape.CORNER_S, BrownMushroomShape.CORNER_W};

    public BlockBrownLargeMushroom() {
        super(MaterialBuilder.makeWood(MaterialColor.field_151650_B).func_226896_b_());
        this.setDropItself(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.func_177229_b(SHAPE));
        return shape == BrownMushroomShape.BOTTOM || shape == BrownMushroomShape.MIDDLE ? new ItemStack((IItemProvider)BlocksRegistry.MUSHROOM_STEM) : new ItemStack((IItemProvider)Items.field_221692_bh);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> stateManager) {
        stateManager.func_206894_a(new Property[]{SHAPE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader view, BlockPos pos, ISelectionContext ePos) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.func_177229_b(SHAPE));
        if (shape == BrownMushroomShape.TOP) {
            return TOP_CENTER_SHAPE;
        }
        if (shape == BrownMushroomShape.MIDDLE || shape == BrownMushroomShape.BOTTOM) {
            return MIDDLE_SHAPE;
        }
        return TOP_EDGE_SHAPE;
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.func_177229_b(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            int offset = this.rotOffset(rotation);
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ROT_CORNER[index + offset & 3]));
        }
        int offset = this.rotOffset(rotation);
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ROT_SIDE[index + offset & 3]));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        BrownMushroomShape shape = (BrownMushroomShape)((Object)state.func_177229_b(SHAPE));
        int index = this.getRotationIndex(shape, ROT_SIDE);
        if (index < 0) {
            index = this.getRotationIndex(shape, ROT_CORNER);
            if (index < 0) {
                return state;
            }
            if (mirror == Mirror.FRONT_BACK) {
                if (shape == BrownMushroomShape.CORNER_E) {
                    shape = BrownMushroomShape.CORNER_W;
                } else if (shape == BrownMushroomShape.CORNER_W) {
                    shape = BrownMushroomShape.CORNER_E;
                }
            } else if (mirror == Mirror.LEFT_RIGHT) {
                if (shape == BrownMushroomShape.CORNER_N) {
                    shape = BrownMushroomShape.CORNER_S;
                } else if (shape == BrownMushroomShape.CORNER_S) {
                    shape = BrownMushroomShape.CORNER_N;
                }
            }
            return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)shape));
        }
        if (mirror == Mirror.FRONT_BACK) {
            if (shape == BrownMushroomShape.SIDE_E) {
                shape = BrownMushroomShape.SIDE_W;
            } else if (shape == BrownMushroomShape.SIDE_W) {
                shape = BrownMushroomShape.SIDE_E;
            }
        } else if (mirror == Mirror.LEFT_RIGHT) {
            if (shape == BrownMushroomShape.SIDE_N) {
                shape = BrownMushroomShape.SIDE_S;
            } else if (shape == BrownMushroomShape.SIDE_S) {
                shape = BrownMushroomShape.SIDE_N;
            }
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(BrownMushroomShape shape, BrownMushroomShape[] rotations) {
        for (int i = 0; i < 4; ++i) {
            if (shape != rotations[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return 0;
        }
        if (rotation == Rotation.CLOCKWISE_90) {
            return 1;
        }
        if (rotation == Rotation.CLOCKWISE_180) {
            return 2;
        }
        return 3;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState neighborState, IWorld world, BlockPos pos, BlockPos neighborPos) {
        switch ((BrownMushroomShape)((Object)state.func_177229_b(SHAPE))) {
            case BOTTOM: {
                return state;
            }
            default: {
                return this.getStateIfSame(state, world, pos.func_177977_b());
            }
            case SIDE_E: 
            case CORNER_E: {
                return this.getStateIfSame(state, world, pos.func_177976_e());
            }
            case SIDE_N: 
            case CORNER_N: {
                return this.getStateIfSame(state, world, pos.func_177968_d());
            }
            case SIDE_S: 
            case CORNER_S: {
                return this.getStateIfSame(state, world, pos.func_177978_c());
            }
            case SIDE_W: 
            case CORNER_W: 
        }
        return this.getStateIfSame(state, world, pos.func_177974_f());
    }

    private BlockState getStateIfSame(BlockState state, IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this ? state : Blocks.field_150350_a.func_176223_P();
    }

    public static enum BrownMushroomShape implements IStringSerializable
    {
        TOP("top"),
        SIDE_N("side_n"),
        SIDE_S("side_s"),
        SIDE_E("side_e"),
        SIDE_W("side_w"),
        CORNER_N("corner_n"),
        CORNER_S("corner_s"),
        CORNER_E("corner_e"),
        CORNER_W("corner_w"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        final String name;

        private BrownMushroomShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

