/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.registry.BlocksRegistry;
import someoneelse.betternetherreforged.structures.StructureType;
import someoneelse.betternetherreforged.structures.decorations.StructureStalactite;
import someoneelse.betternetherreforged.structures.decorations.StructureStalagmite;
import someoneelse.betternetherreforged.structures.plants.StructureBoneGrass;
import someoneelse.betternetherreforged.structures.plants.StructureBoneReef;
import someoneelse.betternetherreforged.structures.plants.StructureFeatherFern;
import someoneelse.betternetherreforged.structures.plants.StructureJellyfishMushroom;
import someoneelse.betternetherreforged.structures.plants.StructureLumabusVine;
import someoneelse.betternetherreforged.structures.plants.StructureReeds;

public class NetherBoneReef
extends NetherBiome {
    public NetherBoneReef(String name) {
        super(new BiomeDefinition(name).setFogColor(47, 221, 202).setLoop(SoundEvents.field_232711_f_).setAdditions(SoundEvents.field_232701_e_).setMood(SoundEvents.field_232722_g_).setStalactites(false).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239815_ao_, 0.01f)));
        this.addStructure("bone_stalactite", new StructureStalagmite(BlocksRegistry.BONE_STALACTITE, BlocksRegistry.BONE_BLOCK), StructureType.FLOOR, 0.05f, true);
        this.addStructure("nether_reed", new StructureReeds(), StructureType.FLOOR, 0.5f, false);
        this.addStructure("bone_reef", new StructureBoneReef(), StructureType.FLOOR, 0.2f, true);
        this.addStructure("jellyfish_mushroom", new StructureJellyfishMushroom(), StructureType.FLOOR, 0.02f, true);
        this.addStructure("feather_fern", new StructureFeatherFern(), StructureType.FLOOR, 0.05f, true);
        this.addStructure("bone_grass", new StructureBoneGrass(), StructureType.FLOOR, 0.1f, false);
        this.addStructure("bone_stalagmite", new StructureStalactite(BlocksRegistry.BONE_STALACTITE, BlocksRegistry.BONE_BLOCK), StructureType.CEIL, 0.05f, true);
        this.addStructure("lumabus_vine", new StructureLumabusVine(), StructureType.CEIL, 0.3f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        BlocksHelper.setWithoutUpdate(world, pos, BlocksRegistry.MUSHROOM_GRASS.func_176223_P());
    }
}

