/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.ParticleEffectAmbience;
import someoneelse.betternetherreforged.BlocksHelper;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.biomes.BiomeDefinition;
import someoneelse.betternetherreforged.biomes.NetherBiome;
import someoneelse.betternetherreforged.structures.StructureType;

public class FloodedDeltas
extends NetherBiome {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public FloodedDeltas(String name) {
        super(new BiomeDefinition(name).setFogColor(104, 95, 112).setLoop(SoundEvents.field_232698_c_).setAdditions(SoundEvents.field_232692_b_).setMood(SoundEvents.field_232700_d_).setMusic(SoundEvents.field_232759_io_).setStalactites(false).setParticleConfig(new ParticleEffectAmbience((IParticleData)ParticleTypes.field_239820_at_, 0.12f)));
        this.addStructure("blackstone_stalactite", STALACTITE_BLACKSTONE, StructureType.FLOOR, 0.2f, true);
        this.addStructure("stalactite_stalactite", STALACTITE_BASALT, StructureType.FLOOR, 0.2f, true);
        this.addStructure("blackstone_stalagmite", STALAGMITE_BLACKSTONE, StructureType.CEIL, 0.1f, true);
        this.addStructure("basalt_stalagmite", STALAGMITE_BASALT, StructureType.CEIL, 0.1f, true);
    }

    @Override
    public void genSurfColumn(IWorld world, BlockPos pos, Random random) {
        POS.func_189533_g((Vector3i)pos);
        int d = MHelper.randRange(2, 4, random);
        BlockState state = this.isLavaValid(world, pos) ? Blocks.field_150353_l.func_176223_P() : (random.nextInt(16) > 0 ? Blocks.field_235337_cO_.func_176223_P() : Blocks.field_150350_a.func_176223_P());
        BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, state);
        if (state.func_177230_c() == Blocks.field_150353_l) {
            world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4).func_201594_d((BlockPos)POS.func_181079_c(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF));
        }
        POS.func_189533_g((Vector3i)pos);
        for (int h = 1; h < d; ++h) {
            POS.func_185336_p(pos.func_177956_o() - h);
            if (!BlocksHelper.isNetherGround(world.func_180495_p((BlockPos)POS))) break;
            BlocksHelper.setWithoutUpdate(world, (BlockPos)POS, Blocks.field_235337_cO_.func_176223_P());
        }
    }

    protected boolean isLavaValid(IWorld world, BlockPos pos) {
        return this.validWall(world, pos.func_177977_b()) && this.validWall(world, pos.func_177978_c()) && this.validWall(world, pos.func_177968_d()) && this.validWall(world, pos.func_177974_f()) && this.validWall(world, pos.func_177976_e());
    }

    protected boolean validWall(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return BlocksHelper.isLava(state) || state.func_235785_r_((IBlockReader)world, pos);
    }
}

