/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged.biomes;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.audio.BackgroundMusicTracks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarvers;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.structure.StructureFeatures;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilders;
import someoneelse.betternetherreforged.MHelper;
import someoneelse.betternetherreforged.config.Configs;

public class BiomeDefinition {
    private final List<StructureFeature<?, ?>> structures = Lists.newArrayList();
    private final List<FeatureInfo> features = Lists.newArrayList();
    private final List<SpawnInfo> mobs = Lists.newArrayList();
    private ParticleEffectAmbience particleConfig;
    private SoundAdditionsAmbience additions;
    private MoodSoundAmbience mood;
    private SoundEvent music;
    private SoundEvent loop;
    private int waterFogColor = 329011;
    private int waterColor = 4159204;
    private int fogColor = 0x330808;
    private boolean defaultOres = true;
    private boolean defaultMobs = true;
    private boolean defaultFeatures = true;
    private boolean defaultStructureFeatures = true;
    private boolean stalactites = true;
    private boolean bnStructures = true;
    private final ResourceLocation id;

    public BiomeDefinition(String name) {
        this.id = new ResourceLocation("betternether", name.replace(' ', '_').toLowerCase());
    }

    public BiomeDefinition(ResourceLocation id) {
        this.id = id;
    }

    public BiomeDefinition setStalactites(boolean value) {
        this.stalactites = value;
        return this;
    }

    public BiomeDefinition setBNStructures(boolean value) {
        this.bnStructures = value;
        return this;
    }

    public BiomeDefinition setDefaultOres(boolean value) {
        this.defaultOres = value;
        return this;
    }

    public BiomeDefinition setDefaultStructureFeatures(boolean value) {
        this.defaultStructureFeatures = value;
        return this;
    }

    public BiomeDefinition setDefaultFeatures(boolean value) {
        this.defaultFeatures = value;
        return this;
    }

    public BiomeDefinition setDefaultMobs(boolean value) {
        this.defaultMobs = value;
        return this;
    }

    public BiomeDefinition setParticleConfig(ParticleEffectAmbience config) {
        this.particleConfig = config;
        return this;
    }

    public BiomeDefinition addMobSpawn(EntityType<?> type, int weight, int minGroupSize, int maxGroupSize) {
        ResourceLocation eID = Registry.field_212629_r.func_177774_c(type);
        if (eID == Registry.field_212629_r.func_212609_b()) {
            String path = "generator.biome." + this.id.func_110624_b() + "." + this.id.func_110623_a() + ".mobs." + eID.func_110624_b() + "." + eID.func_110623_a();
            SpawnInfo info = new SpawnInfo();
            info.type = type;
            info.weight = Configs.BIOMES.getInt(path, "weight", weight);
            info.minGroupSize = Configs.BIOMES.getInt(path, "min_group_size", minGroupSize);
            info.maxGroupSize = Configs.BIOMES.getInt(path, "max_group_size", maxGroupSize);
            this.mobs.add(info);
        }
        return this;
    }

    public BiomeDefinition addStructureFeature(StructureFeature<?, ?> feature) {
        this.structures.add(feature);
        return this;
    }

    public BiomeDefinition addFeature(GenerationStage.Decoration featureStep, ConfiguredFeature<?, ?> feature) {
        FeatureInfo info = new FeatureInfo();
        info.featureStep = featureStep;
        info.feature = feature;
        this.features.add(info);
        return this;
    }

    public BiomeDefinition setFogColor(int r, int g, int b) {
        String path = "generator.biome." + this.id.func_110624_b() + "." + this.id.func_110623_a() + ".fog_color";
        r = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "red", r), (int)0, (int)255);
        g = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "green", g), (int)0, (int)255);
        b = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "blue", b), (int)0, (int)255);
        this.fogColor = MHelper.color(r, g, b);
        return this;
    }

    public BiomeDefinition setWaterColor(int r, int g, int b) {
        String path = "generator.biome." + this.id.func_110624_b() + "." + this.id.func_110623_a() + ".water_color";
        r = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "red", r), (int)0, (int)255);
        g = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "green", g), (int)0, (int)255);
        b = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "blue", b), (int)0, (int)255);
        this.waterColor = MHelper.color(r, g, b);
        return this;
    }

    public BiomeDefinition setWaterFogColor(int r, int g, int b) {
        String path = "generator.biome." + this.id.func_110624_b() + "." + this.id.func_110623_a() + ".water_fog_color";
        r = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "red", r), (int)0, (int)255);
        g = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "green", g), (int)0, (int)255);
        b = MathHelper.func_76125_a((int)Configs.BIOMES.getInt(path, "blue", b), (int)0, (int)255);
        this.waterFogColor = MHelper.color(r, g, b);
        return this;
    }

    public BiomeDefinition setLoop(SoundEvent loop) {
        this.loop = loop;
        return this;
    }

    public BiomeDefinition setMood(SoundEvent mood) {
        this.mood = new MoodSoundAmbience(mood, 6000, 8, 2.0);
        return this;
    }

    public BiomeDefinition setAdditions(SoundEvent additions) {
        this.additions = new SoundAdditionsAmbience(additions, 0.0111);
        return this;
    }

    public BiomeDefinition setMusic(SoundEvent music) {
        this.music = music;
        return this;
    }

    public Biome build() {
        MobSpawnInfo.Builder spawnSettings = new MobSpawnInfo.Builder();
        BiomeGenerationSettings.Builder generationSettings = new BiomeGenerationSettings.Builder();
        BiomeAmbience.Builder effects = new BiomeAmbience.Builder();
        if (this.defaultMobs) {
            this.addDefaultMobs(spawnSettings);
        }
        this.mobs.forEach(spawn -> spawnSettings.func_242575_a(spawn.type.func_220339_d(), new MobSpawnInfo.Spawners(spawn.type, spawn.weight, spawn.minGroupSize, spawn.maxGroupSize)));
        generationSettings.func_242517_a(ConfiguredSurfaceBuilders.field_244183_o);
        this.structures.forEach(structure -> generationSettings.func_242516_a(structure));
        this.features.forEach(info -> generationSettings.func_242513_a(info.featureStep, info.feature));
        if (this.defaultOres) {
            DefaultBiomeFeatures.func_243731_ao((BiomeGenerationSettings.Builder)generationSettings);
        }
        if (this.defaultStructureFeatures) {
            this.addDefaultStructures(generationSettings);
        }
        if (this.defaultFeatures) {
            this.addDefaultFeatures(generationSettings);
        }
        effects.func_242539_d(this.fogColor).func_235246_b_(this.waterColor).func_235248_c_(this.waterFogColor).func_235239_a_(this.fogColor);
        if (this.loop != null) {
            effects.func_235241_a_(this.loop);
        }
        if (this.mood != null) {
            effects.func_235243_a_(this.mood);
        }
        if (this.additions != null) {
            effects.func_235242_a_(this.additions);
        }
        if (this.particleConfig != null) {
            effects.func_235244_a_(this.particleConfig);
        }
        effects.func_235240_a_(BackgroundMusicTracks.func_232677_a_((SoundEvent)(this.music != null ? this.music : SoundEvents.field_232760_ip_)));
        return new Biome.Builder().func_205415_a(Biome.RainType.NONE).func_205419_a(Biome.Category.NETHER).func_205421_a(0.1f).func_205420_b(0.2f).func_205414_c(2.0f).func_205417_d(0.0f).func_235097_a_(effects.func_235238_a_()).func_242458_a(spawnSettings.func_242577_b()).func_242457_a(generationSettings.func_242508_a()).func_242455_a();
    }

    private void addDefaultStructures(BiomeGenerationSettings.Builder generationSettings) {
        generationSettings.func_242516_a(StructureFeatures.field_244134_E);
        generationSettings.func_242516_a(StructureFeatures.field_244149_o);
        generationSettings.func_242516_a(StructureFeatures.field_244153_s);
        generationSettings.func_242512_a(GenerationStage.Carving.AIR, ConfiguredCarvers.field_243772_f);
        generationSettings.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243828_aa);
    }

    private void addDefaultFeatures(BiomeGenerationSettings.Builder generationSettings) {
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243832_ae);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243839_al);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243840_am);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243952_l);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243953_m);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243821_aT);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243822_aU);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243884_bd);
        generationSettings.func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Features.field_243830_ac);
    }

    private void addDefaultMobs(MobSpawnInfo.Builder spawnSettings) {
        spawnSettings.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200811_y, 50, 4, 4));
        spawnSettings.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_233592_ba_, 100, 4, 4));
        spawnSettings.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200771_K, 2, 4, 4));
        spawnSettings.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_200803_q, 1, 4, 4));
        spawnSettings.func_242575_a(EntityClassification.MONSTER, new MobSpawnInfo.Spawners(EntityType.field_233591_ai_, 15, 4, 4));
        spawnSettings.func_242575_a(EntityClassification.CREATURE, new MobSpawnInfo.Spawners(EntityType.field_233589_aE_, 60, 1, 2));
    }

    public ResourceLocation getID() {
        return this.id;
    }

    public boolean hasStalactites() {
        return this.stalactites;
    }

    public boolean hasBNStructures() {
        return this.bnStructures;
    }

    private static final class FeatureInfo {
        GenerationStage.Decoration featureStep;
        ConfiguredFeature<?, ?> feature;

        private FeatureInfo() {
        }
    }

    private static final class SpawnInfo {
        EntityType<?> type;
        int weight;
        int minGroupSize;
        int maxGroupSize;

        private SpawnInfo() {
        }
    }
}

