/*
 * Decompiled with CFR 0.152.
 */
package someoneelse.betternetherreforged;

import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.LavaFluid;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import someoneelse.betternetherreforged.NetherTags;
import someoneelse.betternetherreforged.blocks.BlockFarmland;
import someoneelse.betternetherreforged.registry.BlocksRegistry;

public class BlocksHelper {
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 19;
    public static final int SET_UPDATE = 3;
    public static final Direction[] HORIZONTAL = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final Vector3i[] OFFSETS = new Vector3i[]{new Vector3i(-1, -1, -1), new Vector3i(-1, -1, 0), new Vector3i(-1, -1, 1), new Vector3i(-1, 0, -1), new Vector3i(-1, 0, 0), new Vector3i(-1, 0, 1), new Vector3i(-1, 1, -1), new Vector3i(-1, 1, 0), new Vector3i(-1, 1, 1), new Vector3i(0, -1, -1), new Vector3i(0, -1, 0), new Vector3i(0, -1, 1), new Vector3i(0, 0, -1), new Vector3i(0, 0, 0), new Vector3i(0, 0, 1), new Vector3i(0, 1, -1), new Vector3i(0, 1, 0), new Vector3i(0, 1, 1), new Vector3i(1, -1, -1), new Vector3i(1, -1, 0), new Vector3i(1, -1, 1), new Vector3i(1, 0, -1), new Vector3i(1, 0, 0), new Vector3i(1, 0, 1), new Vector3i(1, 1, -1), new Vector3i(1, 1, 0), new Vector3i(1, 1, 1)};

    public static boolean isLava(BlockState state) {
        return state.func_204520_s().func_206886_c() instanceof LavaFluid;
    }

    public static boolean isNetherrack(BlockState state) {
        return state.func_235714_a_(NetherTags.Blocks.NETHERRACK);
    }

    public static boolean isSoulSand(BlockState state) {
        return state.func_235714_a_(NetherTags.Blocks.SOUL_GROUND);
    }

    public static boolean isNetherGround(BlockState state) {
        return BlocksHelper.isOtherNetherGround(state) || BlocksHelper.isNetherrack(state) || BlocksHelper.isSoulSand(state) || BlocksHelper.isNetherMycelium(state) || BlocksHelper.isNylium(state);
    }

    public static boolean isNetherGroundMagma(BlockState state) {
        return BlocksHelper.isNetherGround(state) || state.func_177230_c() == Blocks.field_196814_hQ;
    }

    public static boolean isBone(BlockState state) {
        Block b = state.func_177230_c();
        return b == Blocks.field_189880_di || b == BlocksRegistry.BONE_BLOCK;
    }

    public static boolean isNetherMycelium(BlockState state) {
        return state.func_235714_a_(NetherTags.Blocks.MYCELIUM);
    }

    public static void setWithUpdate(IWorld world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 3);
    }

    public static void setWithoutUpdate(IWorld world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 19);
    }

    public static int upRay(IWorld world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.func_175623_d(pos.func_177981_b(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(IWorld world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.func_175623_d(pos.func_177979_c(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static BlockState rotateHorizontal(BlockState state, Rotation rotation, Property<Direction> facing) {
        return (BlockState)state.func_206870_a(facing, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b(facing)));
    }

    public static BlockState mirrorHorizontal(BlockState state, Mirror mirror, Property<Direction> facing) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b(facing)));
    }

    public static int getLengthDown(ServerWorld world, BlockPos pos, Block block) {
        int count = 1;
        while (world.func_180495_p(pos.func_177979_c(count)).func_177230_c() == block) {
            ++count;
        }
        return count;
    }

    public static boolean isFertile(BlockState state) {
        return state.func_177230_c() instanceof BlockFarmland;
    }

    public static void cover(IWorld world, BlockPos center, Block ground, BlockState cover, int radius, Random random) {
        HashSet<Object> points = new HashSet<Object>();
        HashSet<BlockPos> points2 = new HashSet<BlockPos>();
        if (world.func_180495_p(center).func_177230_c() == ground) {
            points.add(center);
            points2.add(center);
            for (int i = 0; i < radius; ++i) {
                for (BlockPos blockPos : points) {
                    for (Vector3i offset : OFFSETS) {
                        if (!random.nextBoolean()) continue;
                        BlockPos pos2 = blockPos.func_177971_a(offset);
                        if (!random.nextBoolean() || world.func_180495_p(pos2).func_177230_c() != ground || points.contains(pos2)) continue;
                        points2.add(pos2);
                    }
                }
                points.addAll(points2);
                points2.clear();
            }
            for (BlockPos blockPos : points) {
                BlocksHelper.setWithoutUpdate(world, blockPos, cover);
            }
        }
    }

    public static boolean isNylium(BlockState state) {
        return state.func_235714_a_(NetherTags.Blocks.NYLIUM);
    }

    public static boolean isOtherNetherGround(BlockState state) {
        return state.func_235714_a_(NetherTags.Blocks.OTHER_NETHER_GROUND);
    }
}

