/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.item;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.darkhax.bookshelf.util.RecipeUtils;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.util.Lazy;

public class ItemTier
implements IItemTier {
    private final int maxUses;
    private final float efficiency;
    private final float damage;
    private final int harvestLevel;
    private final int enchantability;
    private final Lazy<Ingredient> repairSupplier;

    @SafeVarargs
    public static ItemTier createFromTags(int maxUses, float efficiency, float damage, int harvestLevel, int enchantability, Supplier<Tag<Item>> ... repairItems) {
        return new ItemTier(maxUses, efficiency, damage, harvestLevel, enchantability, () -> RecipeUtils.ingredientFromTags((Tag[])Stream.of(repairItems).map(Supplier::get).toArray(Tag[]::new)));
    }

    public static ItemTier createFromTag(int maxUses, float efficiency, float damage, int harvestLevel, int enchantability, Supplier<Tag<Item>> repairItems) {
        return new ItemTier(maxUses, efficiency, damage, harvestLevel, enchantability, () -> Ingredient.func_199805_a((ITag)((ITag)repairItems.get())));
    }

    @SafeVarargs
    public static ItemTier createFromItem(int maxUses, float efficiency, float damage, int harvestLevel, int enchantability, Supplier<Item> ... repairItems) {
        return new ItemTier(maxUses, efficiency, damage, harvestLevel, enchantability, () -> Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])Stream.of(repairItems).map(Supplier::get).toArray(Item[]::new))));
    }

    @SafeVarargs
    public static ItemTier createFromStack(int maxUses, float efficiency, float damage, int harvestLevel, int enchantability, Supplier<ItemStack> ... repairItems) {
        return new ItemTier(maxUses, efficiency, damage, harvestLevel, enchantability, () -> Ingredient.func_193369_a((ItemStack[])((ItemStack[])Stream.of(repairItems).map(Supplier::get).toArray(ItemStack[]::new))));
    }

    public ItemTier(int maxUses, float efficiency, float damage, int harvestLevel, int enchantability, Supplier<Ingredient> repairItems) {
        this.maxUses = maxUses;
        this.efficiency = efficiency;
        this.damage = damage;
        this.harvestLevel = harvestLevel;
        this.enchantability = enchantability;
        this.repairSupplier = Lazy.of(repairItems);
    }

    public int func_200926_a() {
        return this.maxUses;
    }

    public float func_200928_b() {
        return this.efficiency;
    }

    public float func_200929_c() {
        return this.damage;
    }

    public int func_200925_d() {
        return this.harvestLevel;
    }

    public int func_200927_e() {
        return this.enchantability;
    }

    public Ingredient func_200924_f() {
        return (Ingredient)this.repairSupplier.get();
    }
}

