/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;

public class EnchantmentTicking
extends Enchantment {
    private static final List<EnchantmentTicking> tickingEnchantments = new ArrayList<EnchantmentTicking>();
    private final EquipmentSlotType[] validSlots;

    public EnchantmentTicking(Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
        this.validSlots = slots;
        if (tickingEnchantments.isEmpty()) {
            MinecraftForge.EVENT_BUS.addListener(EnchantmentTicking::handleTickingEnchantments);
        }
        tickingEnchantments.add(this);
    }

    public void onUserTick(LivingEntity user, int level) {
    }

    public void onItemTick(LivingEntity user, int level, ItemStack item, EquipmentSlotType slot) {
    }

    private static void handleTickingEnchantments(LivingEvent.LivingUpdateEvent event) {
        for (EnchantmentTicking tickingEnch : tickingEnchantments) {
            int totalLevel = 0;
            for (EquipmentSlotType validSlot : tickingEnch.validSlots) {
                ItemStack stack = event.getEntityLiving().func_184582_a(validSlot);
                int level = EnchantmentHelper.func_77506_a((Enchantment)tickingEnch, (ItemStack)stack);
                if (level <= 0) continue;
                totalLevel += level;
                tickingEnch.onItemTick(event.getEntityLiving(), level, stack, validSlot);
            }
            tickingEnch.onUserTick(event.getEntityLiving(), totalLevel);
        }
    }
}

