/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.blocks.RiceUpperCropBlock;
import vectorwing.farmersdelight.registry.ModBlocks;
import vectorwing.farmersdelight.registry.ModItems;

public class RiceCropBlock
extends BushBlock
implements IGrowable,
ILiquidContainer {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public static final BooleanProperty SUPPORTING = BooleanProperty.func_177716_a((String)"supporting");
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public RiceCropBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SUPPORTING, (Comparable)Boolean.valueOf(false)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        float chance;
        int age;
        super.func_225534_a_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 6 && (age = this.getAge(state)) <= this.getMaxAge() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (chance = 10.0f)) + 1) == 0 ? 1 : 0) != 0)) {
            if (age == this.getMaxAge()) {
                RiceUpperCropBlock riceUpper = (RiceUpperCropBlock)ModBlocks.RICE_UPPER_CROP.get();
                if (riceUpper.func_176223_P().func_196955_c((IWorldReader)worldIn, pos.func_177984_a()) && worldIn.func_175623_d(pos.func_177984_a())) {
                    worldIn.func_175656_a(pos.func_177984_a(), riceUpper.func_176223_P());
                    ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
                }
            } else {
                worldIn.func_180501_a(pos, this.withAge(age + 1), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.getAgeProperty())];
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        FluidState fluid = worldIn.func_204610_c(pos);
        return super.func_196260_a(state, worldIn, pos) && fluid.func_206884_a((ITag)FluidTags.field_206959_a) && fluid.func_206882_g() == 8;
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return super.func_200014_a_(state, worldIn, pos) || Tags.Blocks.DIRT.func_230235_a_((Object)state.func_177230_c());
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public int getMaxAge() {
        return 3;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)ModItems.RICE.get());
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, SUPPORTING});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!state.func_196958_f()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
            if (facing == Direction.UP) {
                return (BlockState)state.func_206870_a((Property)SUPPORTING, (Comparable)Boolean.valueOf(this.isSupportingRiceUpper(facingState)));
            }
        }
        return state;
    }

    public boolean isSupportingRiceUpper(BlockState topState) {
        return topState.func_177230_c() == ModBlocks.RICE_UPPER_CROP.get();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        return fluid.func_206884_a((ITag)FluidTags.field_206959_a) && fluid.func_206882_g() == 8 ? super.func_196258_a(context) : null;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        BlockState upperState = worldIn.func_180495_p(pos.func_177984_a());
        if (upperState.func_177230_c() instanceof RiceUpperCropBlock) {
            return !((RiceUpperCropBlock)upperState.func_177230_c()).func_185525_y(upperState);
        }
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    protected int getBonemealAgeIncrease(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)1, (int)4);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int ageGrowth = Math.min(this.getAge(state) + this.getBonemealAgeIncrease((World)worldIn), 7);
        if (ageGrowth <= this.getMaxAge()) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(ageGrowth)));
        } else {
            BlockState top = worldIn.func_180495_p(pos.func_177984_a());
            if (top.func_177230_c() == ModBlocks.RICE_UPPER_CROP.get()) {
                IGrowable growable = (IGrowable)worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
                if (growable.func_176473_a((IBlockReader)worldIn, pos.func_177984_a(), top, false)) {
                    growable.func_225535_a_(worldIn, worldIn.field_73012_v, pos.func_177984_a(), top);
                }
            } else {
                RiceUpperCropBlock riceUpper = (RiceUpperCropBlock)ModBlocks.RICE_UPPER_CROP.get();
                int remainingGrowth = ageGrowth - this.getMaxAge() - 1;
                if (riceUpper.func_176223_P().func_196955_c((IWorldReader)worldIn, pos.func_177984_a()) && worldIn.func_175623_d(pos.func_177984_a())) {
                    worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(this.getMaxAge())));
                    worldIn.func_180501_a(pos.func_177984_a(), (BlockState)riceUpper.func_176223_P().func_206870_a((Property)RiceUpperCropBlock.RICE_AGE, (Comparable)Integer.valueOf(remainingGrowth)), 2);
                }
            }
        }
    }

    public FluidState func_204507_t(BlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return false;
    }
}

