/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure.structures;

import net.joefoxe.hexerei.world.structure.ModStructures;
import net.joefoxe.hexerei.world.structure.structures.AbstractBaseStructure;
import net.joefoxe.hexerei.world.structure.structures.StructureUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.MarginedStructureStart;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.Lazy;

public class GenericJigsawStructure
extends AbstractBaseStructure<NoFeatureConfig> {
    protected final ResourceLocation startPool;
    protected final Lazy<Integer> structureSize;
    protected final int centerOffset;
    protected final int biomeRange;
    protected final int structureBlacklistRange;
    protected final int allowTerrainHeightRange;
    protected final int terrainHeightRadius;
    protected final int minHeightLimit;
    protected int fixedYSpawn;
    protected boolean useHeightmap;
    protected boolean cannotSpawnInWater;

    public GenericJigsawStructure(ResourceLocation poolID, Lazy<Integer> structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater) {
        super(NoFeatureConfig.field_236558_a_);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.centerOffset = centerOffset;
        this.biomeRange = biomeRange;
        this.structureBlacklistRange = structureBlacklistRange;
        this.allowTerrainHeightRange = allowTerrainHeightRange;
        this.terrainHeightRadius = terrainHeightRadius;
        this.minHeightLimit = minHeightLimit;
        this.fixedYSpawn = fixedYSpawn;
        this.useHeightmap = useHeightmap;
        this.cannotSpawnInWater = cannotSpawnInWater;
        ModStructures.HEXEREI_STRUCTURE_START_PIECES.add(this.startPool);
    }

    protected boolean func_230363_a_(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig defaultFeatureConfig) {
        if (this.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = chunkX - this.terrainHeightRadius; curChunkX <= chunkX + this.terrainHeightRadius; ++curChunkX) {
                for (int curChunkZ = chunkZ - this.terrainHeightRadius; curChunkZ <= chunkZ + this.terrainHeightRadius; ++curChunkZ) {
                    int height = chunkGenerator.func_222529_a(curChunkX * 16, curChunkZ * 16, Heightmap.Type.WORLD_SURFACE_WG);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= this.minHeightLimit) continue;
                    return false;
                }
            }
            return maxTerrainHeight - minTerrainHeight <= this.allowTerrainHeightRange;
        }
        return true;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((Structure<NoFeatureConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public static class Builder<T extends Builder<T>> {
        protected final ResourceLocation startPool;
        protected Lazy<Integer> structureSize = Lazy.of(() -> 1);
        protected int centerOffset = 0;
        protected int biomeRange = 0;
        protected int structureBlacklistRange = 0;
        protected int allowTerrainHeightRange = -1;
        protected int terrainHeightRadius = 0;
        protected int minHeightLimit = Integer.MIN_VALUE;
        protected int fixedYSpawn = 0;
        protected boolean useHeightmap = true;
        protected boolean cannotSpawnInWater = false;

        public Builder(ResourceLocation startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setStructureSize(ForgeConfigSpec.IntValue structureSize) {
            this.structureSize = Lazy.of(() -> ((ForgeConfigSpec.IntValue)structureSize).get());
            return this.getThis();
        }

        public T setStructureSize(int structureSize) {
            this.structureSize = Lazy.of(() -> structureSize);
            return this.getThis();
        }

        public T setCenterOffset(int centerOffset) {
            this.centerOffset = centerOffset;
            return this.getThis();
        }

        public T setBiomeRange(int biomeRange) {
            this.biomeRange = biomeRange;
            return this.getThis();
        }

        public T setStructureBlacklistRange(int structureBlacklistRange) {
            this.structureBlacklistRange = structureBlacklistRange;
            return this.getThis();
        }

        public T setAllowTerrainHeightRange(int allowTerrainHeightRange) {
            this.allowTerrainHeightRange = allowTerrainHeightRange;
            return this.getThis();
        }

        public T setTerrainHeightRadius(int terrainHeightRadius) {
            this.terrainHeightRadius = terrainHeightRadius;
            return this.getThis();
        }

        public T setMinHeightLimit(int minHeightLimit) {
            this.minHeightLimit = minHeightLimit;
            return this.getThis();
        }

        public T setFixedYSpawn(int fixedYSpawn) {
            this.fixedYSpawn = fixedYSpawn;
            return this.getThis();
        }

        public T doNotUseHeightmap() {
            this.useHeightmap = false;
            return this.getThis();
        }

        public T cannotSpawnInWater() {
            this.cannotSpawnInWater = true;
            return this.getThis();
        }

        public GenericJigsawStructure build() {
            return new GenericJigsawStructure(this.startPool, this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater);
        }
    }

    public class MainStart
    extends MarginedStructureStart<NoFeatureConfig> {
        private final ResourceLocation structureID;

        public MainStart(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox box, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, box, referenceIn, seedIn);
            this.structureID = Registry.field_218361_B.func_177774_c(structureIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager structureManager, int chunkX, int chunkZ, Biome biome, NoFeatureConfig defaultFeatureConfig) {
            BlockPos blockpos = new BlockPos(chunkX * 16, GenericJigsawStructure.this.fixedYSpawn, chunkZ * 16);
            StructureUtils.centerAllPieces(blockpos, this.field_75075_a);
            this.func_202500_a();
            ((StructurePiece)this.field_75075_a.get(0)).func_181138_a(0, GenericJigsawStructure.this.centerOffset, 0);
        }
    }
}

