/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util.message;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageCountUpdate {
    private int x;
    private int y;
    private int z;
    private int slot;
    private int count;
    private boolean failed;

    public MessageCountUpdate(BlockPos pos, int slot, int count) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.slot = slot;
        this.count = count;
        this.failed = false;
    }

    private MessageCountUpdate(boolean failed) {
        this.failed = failed;
    }

    public static MessageCountUpdate decode(ByteBuf buf) {
        try {
            int x = buf.readInt();
            short y = buf.readShort();
            int z = buf.readInt();
            byte slot = buf.readByte();
            int count = buf.readInt();
            return new MessageCountUpdate(new BlockPos(x, (int)y, z), slot, count);
        }
        catch (IndexOutOfBoundsException e) {
            return new MessageCountUpdate(true);
        }
    }

    public static void encode(MessageCountUpdate msg, PacketBuffer buf) {
        buf.writeInt(msg.x);
        buf.writeShort(msg.y);
        buf.writeInt(msg.z);
        buf.writeByte(msg.slot);
        buf.writeInt(msg.count);
    }

    public static void handle(MessageCountUpdate msg, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> MessageCountUpdate.lambda$null$0(msg, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(MessageCountUpdate msg, NetworkEvent.Context ctx) {
        BlockPos pos;
        TileEntity tileEntity;
        ClientWorld world;
        if (!msg.failed && (world = Minecraft.func_71410_x().field_71441_e) != null && (tileEntity = world.func_175625_s(pos = new BlockPos(msg.x, msg.y, msg.z))) instanceof HerbJarTile) {
            ((HerbJarTile)tileEntity).clientUpdateCount(msg.slot, msg.count);
        }
        ctx.setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(MessageCountUpdate msg, Supplier ctx) {
        MessageCountUpdate.handleClient(msg, (NetworkEvent.Context)ctx.get());
    }
}

