/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Objects;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class MixingCauldronRenderer
extends TileEntityRenderer<MixingCauldronTile> {
    public MixingCauldronRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher);
    }

    public void render(MixingCauldronTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float craftPercent = 0.0f;
        if (!Objects.requireNonNull(tileEntityIn.func_145831_w()).func_180495_p(tileEntityIn.func_174877_v()).hasTileEntity()) {
            return;
        }
        craftPercent = (float)((Integer)tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v()).func_177229_b((Property)MixingCauldron.CRAFT_DELAY)).intValue() / 100.0f;
        for (int i = 0; i < 8; ++i) {
            ItemStack item = new ItemStack((IItemProvider)tileEntityIn.getItemInSlot(i));
            if (item.func_190926_b()) continue;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 1.5, 0.5);
            float currentTime = (float)tileEntityIn.func_145831_w().func_82737_E() + partialTicks;
            double itemRotationOffset = 0.8 * (double)i + (double)(craftPercent * (20.0f * craftPercent));
            if ((Integer)tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v()).func_177229_b((Property)MixingCauldron.LEVEL) > 0) {
                matrixStackIn.func_227861_a_(0.0 + Math.sin(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f), -1.15 + 0.2 * ((double)((Integer)tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v()).func_177229_b((Property)MixingCauldron.LEVEL)).intValue() + Math.sin(Math.PI * (double)currentTime / 30.0 + (double)(i * 20)) / 10.0), 0.0 + Math.cos(itemRotationOffset) / (double)(3.5f + craftPercent * craftPercent * 10.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)((double)((float)(45 * i) - 1.0f) + 2.0 * Math.sin((tileEntityIn.degrees + (float)(i * 20)) / 40.0f))));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(82.5 + 5.0 * Math.cos((tileEntityIn.degrees + (float)(i * 22)) / 40.0f))));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-2.5 + 5.0 * Math.cos((tileEntityIn.degrees + (float)(i * 24)) / 40.0f))));
                matrixStackIn.func_227862_a_(1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f, 1.0f - craftPercent * 0.5f);
            } else {
                matrixStackIn.func_227861_a_(0.0 + Math.sin(itemRotationOffset) / 3.5, -1.15, 0.0 + Math.cos(itemRotationOffset) / 3.5);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(45 * i)));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(85.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-2.5f));
            }
            matrixStackIn.func_227862_a_(0.4f, 0.4f, 0.4f);
            this.renderItem(item, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.func_227865_b_();
        }
        ItemStack item2 = new ItemStack((IItemProvider)tileEntityIn.getItemInSlot(8));
        if (!item2.func_190926_b()) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 1.5, 0.5);
            float currentTime = (float)tileEntityIn.func_145831_w().func_82737_E() + partialTicks;
            if ((Integer)tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v()).func_177229_b((Property)MixingCauldron.LEVEL) > 0) {
                matrixStackIn.func_227861_a_(0.0, -1.15 + 0.2 * ((double)((Integer)tileEntityIn.func_145831_w().func_180495_p(tileEntityIn.func_174877_v()).func_177229_b((Property)MixingCauldron.LEVEL)).intValue() + Math.sin(Math.PI * (double)currentTime / 30.0 + 20.0) / 10.0), 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(44.0 + 2.0 * Math.sin((tileEntityIn.degrees + 20.0f) / 40.0f)) - craftPercent * craftPercent * 720.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(82.5 + 5.0 * Math.cos((tileEntityIn.degrees + 22.0f) / 40.0f))));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-2.5 + 5.0 * Math.cos((tileEntityIn.degrees + 24.0f) / 40.0f))));
            } else {
                matrixStackIn.func_227861_a_(0.0, -1.15, 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f - craftPercent * craftPercent * 720.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(85.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-2.5f));
            }
            matrixStackIn.func_227862_a_(0.4f, 0.4f, 0.4f);
            this.renderItem(item2, partialTicks, matrixStackIn, bufferIn, combinedLightIn);
            matrixStackIn.func_227865_b_();
        }
        tileEntityIn.degrees += 1.0f;
        if (tileEntityIn.getItemInSlot(9) == ModItems.BLOOD_SIGIL.get() && tileEntityIn.getItemInSlot(9).getItem() == ModItems.BLOOD_SIGIL.get()) {
            matrixStackIn.func_227860_a_();
            this.renderBlock(matrixStackIn, bufferIn, combinedLightIn, ((Block)ModBlocks.BLOOD_SIGIL.get()).func_176223_P());
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderItem(ItemStack stack, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
    }

    private void renderBlock(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.func_71410_x().func_175602_ab().renderBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
    }
}

