/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import net.joefoxe.hexerei.block.custom.CrystalBall;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class CrystalBallTile
extends TileEntity
implements ITickableTileEntity {
    public int degreesSpun;
    public int bobAmount;
    public float orbOffset = 0.0f;
    public float smallRingOffset = 0.0f;
    public float largeRingOffset = 0.0f;

    public CrystalBallTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public CrystalBallTile() {
        this((TileEntityType)ModTileEntities.CRYSTAL_BALL_TILE.get());
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.func_226277_ct_() - (double)pos.func_177958_n();
        double deltaY = entity.func_226278_cu_() - (double)pos.func_177956_o();
        double deltaZ = entity.func_226281_cx_() - (double)pos.func_177952_p();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    private float moveTo(float input, float movedTo, float speed) {
        float distance = movedTo - input;
        if (Math.abs(distance) <= speed) {
            return movedTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public double func_145833_n() {
        return 4096.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox().func_72314_b(5.0, 5.0, 5.0);
        return aabb;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            float currentTime = this.func_145831_w().func_82737_E();
            if (this.largeRingOffset > -7.0f) {
                this.degreesSpun = this.degreesSpun + 1 < 112 ? ++this.degreesSpun : 0;
            }
            if (((CrystalBall)this.func_195044_w().func_177230_c()).getPlayerNear(this.func_145831_w(), this.func_174877_v())) {
                this.orbOffset = this.moveTo(this.orbOffset, (float)Math.sin(Math.PI * (double)currentTime / 10.0) / 4.0f, 0.25f);
                this.smallRingOffset = this.moveTo(this.smallRingOffset, (float)Math.sin(Math.PI * (double)(currentTime + 20.0f) / 15.0) / 4.0f, 0.25f);
                this.largeRingOffset = this.moveTo(this.largeRingOffset, (float)Math.sin(Math.PI * (double)(currentTime + 40.0f) / 20.0) / 4.0f, 0.35f);
            } else {
                this.orbOffset = this.moveTo(this.orbOffset, -0.5f, 0.1f);
                this.smallRingOffset = this.moveTo(this.smallRingOffset, -4.5f, 0.25f);
                this.largeRingOffset = this.moveTo(this.largeRingOffset, -7.0f, 0.25f);
            }
            return;
        }
        boolean flag = false;
        PlayerList list = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        for (int i = 0; i < list.func_181057_v().size(); ++i) {
            ServerPlayerEntity player = (ServerPlayerEntity)list.func_181057_v().get(i);
            if (!(Math.floor(CrystalBallTile.getDistanceToEntity((Entity)player, this.field_174879_c)) < 4.0)) continue;
            flag = true;
            ((CrystalBall)this.func_195044_w().func_177230_c()).setPlayerNear(this.field_145850_b, this.field_174879_c, this.func_195044_w(), true);
            break;
        }
        if (!flag) {
            ((CrystalBall)this.func_195044_w().func_177230_c()).setPlayerNear(this.field_145850_b, this.field_174879_c, this.func_195044_w(), false);
        }
    }
}

