/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.Coffer;
import net.joefoxe.hexerei.container.CofferContainer;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CofferTile
extends LockableLootTileEntity
implements ITickableTileEntity,
IClearable,
INamedContainerProvider {
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    public int degreesOpened;
    public int buttonToggled = 0;
    public static final int lidOpenAmount = 112;
    public ITextComponent field_213909_b;

    public CofferTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void readInventory(CompoundNBT compound) {
        this.itemHandler.deserializeNBT(compound);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hexerei.coffer");
    }

    public CofferTile() {
        this((TileEntityType)ModTileEntities.COFFER_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.field_213909_b = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        if (this.field_213909_b != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.field_213909_b));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return super.func_189515_b(compound);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new CofferContainer(id, this.field_145850_b, this.field_174879_c, player, player.field_70458_d);
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.items.clear();
    }

    public double func_145833_n() {
        return 4096.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox().func_72314_b(5.0, 5.0, 5.0);
        return aabb;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(36){

            protected void onContentsChanged(int slot) {
                CofferTile.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public Item getItemInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot).func_77973_b();
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            ++num;
        }
        return num;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.func_226277_ct_() - (double)pos.func_177958_n();
        double deltaY = entity.func_226278_cu_() - (double)pos.func_177956_o();
        double deltaZ = entity.func_226281_cx_() - (double)pos.func_177952_p();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public ITextComponent func_145748_c_() {
        return this.field_213909_b != null ? this.field_213909_b : new TranslationTextComponent("");
    }

    public ITextComponent func_200201_e() {
        return this.field_213909_b;
    }

    public boolean func_145818_k_() {
        return this.field_213909_b != null;
    }

    public ITextComponent func_200200_C_() {
        return this.field_213909_b;
    }

    public int getDegreesOpened() {
        return this.degreesOpened;
    }

    public void setDegreesOpened(int degrees) {
        this.degreesOpened = degrees;
    }

    public int getButtonToggled() {
        return this.buttonToggled;
    }

    public void setButtonToggled(int degrees) {
        this.buttonToggled = degrees;
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)false);
        }
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean flag = false;
        PlayerList list = ServerLifecycleHooks.getCurrentServer().func_184103_al();
        for (int i = 0; i < list.func_181057_v().size(); ++i) {
            ServerPlayerEntity player = (ServerPlayerEntity)list.func_181057_v().get(i);
            if (!(Math.floor(CofferTile.getDistanceToEntity((Entity)player, this.field_174879_c)) < 4.0)) continue;
            int distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            flag = true;
            this.degreesOpened = (double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 < 112.0 ? (int)((double)this.degreesOpened + (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0)) : 112;
            ((Coffer)this.func_195044_w().func_177230_c()).setAngle(this.field_145850_b, this.field_174879_c, this.func_195044_w(), this.degreesOpened);
            break;
        }
        if (!flag) {
            int distanceFromSide = 56 - Math.abs(56 - this.degreesOpened);
            this.degreesOpened = (double)this.degreesOpened + Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0 > 0.0 ? (int)((double)this.degreesOpened - (Math.floor((double)distanceFromSide / 56.0 * 6.0) + 2.0)) : 0;
            ((Coffer)this.func_195044_w().func_177230_c()).setAngle(this.field_145850_b, this.field_174879_c, this.func_195044_w(), this.degreesOpened);
        }
    }

    public int func_70302_i_() {
        return 0;
    }
}

