/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import java.util.Optional;
import java.util.function.Supplier;
import net.joefoxe.hexerei.client.renderer.entity.custom.AbstractPigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.EntityAttributeRegistry;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IPigeonAttributeModifier;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.Skill;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IRegistryDelegate;

public class SkillInstance
implements IPigeonAttributeModifier {
    protected final IRegistryDelegate<Skill> skillDelegate;
    protected int level;

    public SkillInstance(Skill SkillIn, int levelIn) {
        this((IRegistryDelegate<Skill>)SkillIn.delegate, levelIn);
    }

    public SkillInstance(Skill SkillIn) {
        this((IRegistryDelegate<Skill>)SkillIn.delegate, 1);
    }

    public SkillInstance(IRegistryDelegate<Skill> skillDelegateIn, int levelIn) {
        this.skillDelegate = skillDelegateIn;
        this.level = levelIn;
    }

    public Skill getSkill() {
        return (Skill)((Object)this.skillDelegate.get());
    }

    public final int level() {
        return this.level;
    }

    public final void setLevel(int levelIn) {
        this.level = levelIn;
    }

    public boolean of(Supplier<Skill> SkillIn) {
        return this.of(SkillIn.get());
    }

    public boolean of(Skill SkillIn) {
        return this.of((IRegistryDelegate<Skill>)SkillIn.delegate);
    }

    public boolean of(IRegistryDelegate<Skill> skillDelegateIn) {
        return skillDelegateIn.equals(this.skillDelegate);
    }

    public SkillInstance copy() {
        return ((Skill)((Object)this.skillDelegate.get())).getDefault(this.level);
    }

    public void writeToNBT(AbstractPigeonEntity canisIn, CompoundNBT compound) {
        compound.func_74768_a("level", this.level());
    }

    public void readFromNBT(AbstractPigeonEntity canisIn, CompoundNBT compound) {
        this.setLevel(compound.func_74762_e("level"));
    }

    public void writeToBuf(PacketBuffer buf) {
        buf.writeInt(this.level());
    }

    public void readFromBuf(PacketBuffer buf) {
        this.setLevel(buf.readInt());
    }

    public final void writeInstance(AbstractPigeonEntity canisIn, CompoundNBT compound) {
        ResourceLocation rl = this.skillDelegate.name();
        if (rl != null) {
            compound.func_74778_a("type", rl.toString());
        }
        this.writeToNBT(canisIn, compound);
    }

    public static Optional<SkillInstance> readInstance(AbstractPigeonEntity canisIn, CompoundNBT compound) {
        ResourceLocation rl = ResourceLocation.func_208304_a((String)compound.func_74779_i("type"));
        if (EntityAttributeRegistry.SKILLS.containsKey(rl)) {
            SkillInstance inst = ((Skill)EntityAttributeRegistry.SKILLS.getValue(rl)).getDefault();
            inst.readFromNBT(canisIn, compound);
            return Optional.of(inst);
        }
        EntityAttributeRegistry.LOGGER.warn("Failed to load Skill {}", (Object)rl);
        return Optional.empty();
    }

    public <T extends SkillInstance> T cast(Class<T> type) {
        if (this.getClass().isAssignableFrom(type)) {
            return (T)this;
        }
        throw new RuntimeException("Could not cast " + this.getClass().getName() + " to " + type.getName());
    }

    public String toString() {
        return String.format("%s [skill: %s, level: %d]", this.getClass().getSimpleName(), this.skillDelegate.name());
    }

    @Override
    public void init(AbstractPigeonEntity pidgeonIn) {
    }

    public void set(AbstractPigeonEntity pidgeonIn, int levelBefore) {
    }

    public boolean hasRenderer() {
        return this.getSkill().hasRenderer();
    }
}

