/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonReviveData;
import net.joefoxe.hexerei.util.NBTUtilities;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class PigeonReviveStorage
extends WorldSavedData {
    private Map<UUID, PigeonReviveData> reviveDataMap = Maps.newConcurrentMap();

    public PigeonReviveStorage() {
        super("hexereiPigeonGraveyard");
    }

    public static PigeonReviveStorage get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Tried to access pidgeon revive data from the client. This should not happen...");
        }
        ServerWorld overworld = world.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (PigeonReviveStorage)storage.func_215752_a(PigeonReviveStorage::new, "hexereiPigeonGraveyard");
    }

    public Stream<PigeonReviveData> getPigeons(@Nonnull UUID ownerId) {
        return this.reviveDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<PigeonReviveData> getPigeons(@Nonnull String ownerName) {
        return this.reviveDataMap.values().stream().filter(data -> ownerName.equals(data.getOwnerName()));
    }

    @Nullable
    public PigeonReviveData getData(UUID uuid) {
        if (this.reviveDataMap.containsKey(uuid)) {
            return this.reviveDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public PigeonReviveData remove(UUID uuid) {
        if (this.reviveDataMap.containsKey(uuid)) {
            PigeonReviveData storage = this.reviveDataMap.remove(uuid);
            this.func_76185_a();
            return storage;
        }
        return null;
    }

    @Nullable
    public PigeonReviveData putData(PigeonEntity pidgeonIn) {
        UUID uuid = pidgeonIn.func_110124_au();
        PigeonReviveData storage = new PigeonReviveData(this, uuid);
        storage.populate(pidgeonIn);
        this.reviveDataMap.put(uuid, storage);
        this.func_76185_a();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.reviveDataMap.keySet());
    }

    public Collection<PigeonReviveData> getAll() {
        return Collections.unmodifiableCollection(this.reviveDataMap.values());
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.reviveDataMap.clear();
        ListNBT list = nbt.func_150295_c("reviveData", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT reviveCompound = list.func_150305_b(i);
            UUID uuid = NBTUtilities.getUniqueId(reviveCompound, "uuid");
            PigeonReviveData reviveData = new PigeonReviveData(this, uuid);
            reviveData.read(reviveCompound);
            if (uuid == null) {
                Hexerei.LOGGER.info("Failed to load pidgeon revive data. Please complain to Joe...");
                Hexerei.LOGGER.info((Object)reviveData);
                continue;
            }
            this.reviveDataMap.put(uuid, reviveData);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, PigeonReviveData> entry : this.reviveDataMap.entrySet()) {
            CompoundNBT reviveCompound = new CompoundNBT();
            PigeonReviveData reviveData = entry.getValue();
            NBTUtilities.putUniqueId(reviveCompound, "uuid", entry.getKey());
            reviveData.write(reviveCompound);
            list.add((Object)reviveCompound);
        }
        compound.func_218657_a("reviveData", (INBT)list);
        return compound;
    }
}

