/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.IBirdData;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonReviveStorage;
import net.joefoxe.hexerei.util.NBTUtilities;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;

public class PigeonReviveData
implements IBirdData {
    private final PigeonReviveStorage storage;
    private final UUID uuid;
    private CompoundNBT data;
    private static final List<String> TAGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"Pos", "Health", "Motion", "Rotation", "FallDistance", "Fire", "Air", "OnGround", "Dimension", "PortalCooldown", "Passengers", "Leash", "InLove", "Leash", "HurtTime", "HurtByTimestamp", "DeathTime", "AbsorptionAmount", "FallFlying", "Brain", "Sitting"});

    protected PigeonReviveData(PigeonReviveStorage storageIn, UUID uuid) {
        this.storage = storageIn;
        this.uuid = uuid;
    }

    @Override
    public UUID getBirdId() {
        return this.uuid;
    }

    @Override
    public String getBirdName() {
        ITextComponent name = NBTUtilities.getTextComponent(this.data, "CustomName");
        return name == null ? "" : name.getString();
    }

    @Override
    public UUID getOwnerId() {
        String str = this.data.func_74779_i("OwnerUUID");
        return "".equals(str) ? null : UUID.fromString(str);
    }

    @Override
    public String getOwnerName() {
        ITextComponent name = NBTUtilities.getTextComponent(this.data, "lastKnownOwnerName");
        return name == null ? "" : name.getString();
    }

    public void populate(PigeonEntity pigeonIn) {
        this.data = new CompoundNBT();
        pigeonIn.func_189511_e(this.data);
        for (String tag : TAGS_TO_REMOVE) {
            this.data.func_82580_o(tag);
        }
        this.data.func_82580_o("UUID");
        this.data.func_82580_o("LoveCause");
    }

    @Nullable
    public PigeonEntity respawn(ServerWorld worldIn, PlayerEntity playerIn, BlockPos pos) {
        PigeonEntity pigeon = (PigeonEntity)((EntityType)ModEntityTypes.PIGEON.get()).func_220342_a(worldIn, null, null, playerIn, pos, SpawnReason.TRIGGERED, true, false);
        if (pigeon == null) {
            return null;
        }
        CompoundNBT compoundnbt = pigeon.func_189511_e(new CompoundNBT());
        UUID uuid = pigeon.func_110124_au();
        compoundnbt.func_197643_a(this.data);
        pigeon.func_184221_a(uuid);
        pigeon.func_70020_e(compoundnbt);
        return pigeon;
    }

    public void read(CompoundNBT compound) {
        this.data = compound.func_74775_l("data");
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_218657_a("data", (INBT)this.data);
        return compound;
    }
}

