/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import net.joefoxe.hexerei.client.renderer.entity.custom.BroomEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.BuffZombieEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.CrowEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.util.PigeonAttributes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="hexerei", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntityTypes {
    public static DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"hexerei");
    public static final RegistryObject<EntityType<BuffZombieEntity>> BUFF_ZOMBIE = ENTITY_TYPES.register("buff_zombie", () -> EntityType.Builder.func_220322_a(BuffZombieEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(1.0f, 3.0f).func_206830_a(new ResourceLocation("hexerei", "buff_zombie").toString()));
    public static final RegistryObject<EntityType<PigeonEntity>> PIGEON = ENTITY_TYPES.register("pigeon", () -> EntityType.Builder.func_220322_a(PigeonEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.3f).func_206830_a(new ResourceLocation("hexerei", "pigeon").toString()));
    public static final RegistryObject<EntityType<BroomEntity>> BROOM = ENTITY_TYPES.register("broom", () -> EntityType.Builder.func_220322_a(BroomEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.175f, 0.3625f).func_233606_a_(10).func_206830_a(new ResourceLocation("hexerei", "broom").toString()));
    public static final RegistryObject<EntityType<CrowEntity>> CROW = ENTITY_TYPES.register("crow", () -> EntityType.Builder.func_220322_a(CrowEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.35f, 0.35f).func_206830_a(new ResourceLocation("hexerei", "crow").toString()));

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }

    public static void addEntityAttributes() {
        GlobalEntityTypeAttributes.put((EntityType)((EntityType)PIGEON.get()), (AttributeModifierMap)MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 80.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233824_g_, 1.25).func_233815_a_((Attribute)PigeonAttributes.CRIT_CHANCE.get(), 0.01).func_233815_a_((Attribute)PigeonAttributes.CRIT_BONUS.get(), 1.0).func_233813_a_());
    }

    private static <T extends Entity> EntityType<T> register2(String key, EntityType.Builder<T> builder) {
        return (EntityType)Registry.func_218325_a((Registry)Registry.field_212629_r, (String)key, (Object)builder.func_206830_a(key));
    }

    private static final EntityType registerEntity(EntityType.Builder builder, String entityName) {
        ResourceLocation nameLoc = new ResourceLocation("hexerei", entityName);
        return (EntityType)builder.func_206830_a(entityName).setRegistryName(nameLoc);
    }

    public static Predicate<LivingEntity> buildPredicateFromTag(ITag entityTag) {
        if (entityTag == null) {
            return Predicates.alwaysFalse();
        }
        return e -> e.func_70089_S() && e.func_200600_R().func_220341_a(entityTag);
    }

    public static Predicate<LivingEntity> buildPredicateFromTagTameable(ITag entityTag, LivingEntity owner) {
        if (entityTag == null) {
            return Predicates.alwaysFalse();
        }
        return e -> e.func_70089_S() && e.func_200600_R().func_220341_a(entityTag) && !owner.func_184191_r((Entity)e);
    }
}

