/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.CommandDispatcher;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.FoodHandler;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonReviveCommand;
import net.joefoxe.hexerei.client.renderer.entity.render.BroomRenderer;
import net.joefoxe.hexerei.client.renderer.entity.render.BuffZombieRenderer;
import net.joefoxe.hexerei.client.renderer.entity.render.PigeonRenderer;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.ModContainers;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.fluid.ModFluids;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.particle.ModParticleTypes;
import net.joefoxe.hexerei.screen.CofferScreen;
import net.joefoxe.hexerei.screen.HerbJarScreen;
import net.joefoxe.hexerei.screen.MixingCauldronScreen;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.tileentity.renderer.BookOfShadowsAltarRenderer;
import net.joefoxe.hexerei.tileentity.renderer.CandleDipperRenderer;
import net.joefoxe.hexerei.tileentity.renderer.CandleRenderer;
import net.joefoxe.hexerei.tileentity.renderer.CofferRenderer;
import net.joefoxe.hexerei.tileentity.renderer.CrystalBallRenderer;
import net.joefoxe.hexerei.tileentity.renderer.HerbJarRenderer;
import net.joefoxe.hexerei.tileentity.renderer.MixingCauldronRenderer;
import net.joefoxe.hexerei.util.HexereiConstants;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.PigeonAttributes;
import net.joefoxe.hexerei.util.PigeonPacketHandler;
import net.joefoxe.hexerei.util.PigeonRegistries;
import net.joefoxe.hexerei.util.PigeonSkills;
import net.joefoxe.hexerei.util.SeedFoodHandler;
import net.joefoxe.hexerei.util.SerializersHexerei;
import net.joefoxe.hexerei.world.biome.ModBiomes;
import net.joefoxe.hexerei.world.gen.ModBiomeGeneration;
import net.joefoxe.hexerei.world.gen.ModFeatures;
import net.joefoxe.hexerei.world.processor.DarkCovenLegProcessor;
import net.joefoxe.hexerei.world.processor.MangroveTreeLegProcessor;
import net.joefoxe.hexerei.world.processor.WitchHutLegProcessor;
import net.joefoxe.hexerei.world.structure.ModStructures;
import net.minecraft.block.Block;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.CommandSource;
import net.minecraft.data.DataGenerator;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.AxeItem;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hexerei")
public class Hexerei {
    public static final String MOD_ID = "hexerei";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)HexereiConstants.CHANNEL_NAME).clientAcceptedVersions(HexereiConstants.PROTOCOL_VERSION::equals).serverAcceptedVersions(HexereiConstants.PROTOCOL_VERSION::equals).networkProtocolVersion(HexereiConstants.PROTOCOL_VERSION::toString).simpleChannel();
    public static IStructureProcessorType<WitchHutLegProcessor> WITCH_HUT_LEG_PROCESSOR = () -> WitchHutLegProcessor.CODEC;
    public static IStructureProcessorType<DarkCovenLegProcessor> DARK_COVEN_LEG_PROCESSOR = () -> DarkCovenLegProcessor.CODEC;
    public static IStructureProcessorType<MangroveTreeLegProcessor> MANGROVE_TREE_LEG_PROCESSOR = () -> MangroveTreeLegProcessor.CODEC;

    public Hexerei() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::gatherData);
        ModItems.register(eventBus);
        ModBlocks.register(eventBus);
        ModFluids.register(eventBus);
        ModTileEntities.register(eventBus);
        ModContainers.register(eventBus);
        ModRecipeTypes.register(eventBus);
        ModParticleTypes.PARTICLES.register(eventBus);
        ModFeatures.register(eventBus);
        ModStructures.register(eventBus);
        ModBiomes.register(eventBus);
        SerializersHexerei.SERIALIZERS.register(eventBus);
        PigeonSkills.SKILLS.register(eventBus);
        PigeonAttributes.ATTRIBUTES.register(eventBus);
        eventBus.addListener(PigeonRegistries::newRegistry);
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onServerStarting);
        forgeEventBus.addListener(this::registerCommands);
        ModEntityTypes.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, HexConfig.COMMON_CONFIG);
        HexConfig.loadConfig(HexConfig.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("Hexerei-common.toml"));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        PigeonPacketHandler.init();
        FoodHandler.registerHandler(new SeedFoodHandler());
        PigeonReviveCommand.registerSerializers();
        PigeonEntity.initDataParameters();
        ModEntityTypes.addEntityAttributes();
        event.enqueueWork(() -> {
            ModBiomeGeneration.generateBiomes();
            AxeItem.field_203176_a = new ImmutableMap.Builder().putAll(AxeItem.field_203176_a).put((Object)ModBlocks.MAHOGANY_LOG.get(), (Object)ModBlocks.STRIPPED_MAHOGANY_LOG.get()).put((Object)ModBlocks.MAHOGANY_WOOD.get(), (Object)ModBlocks.STRIPPED_MAHOGANY_WOOD.get()).put((Object)ModBlocks.WILLOW_LOG.get(), (Object)ModBlocks.STRIPPED_WILLOW_LOG.get()).put((Object)ModBlocks.WILLOW_WOOD.get(), (Object)ModBlocks.STRIPPED_WILLOW_WOOD.get()).build();
            ModStructures.setupStructures();
            Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)new ResourceLocation(MOD_ID, "witch_hut_leg_processor"), WITCH_HUT_LEG_PROCESSOR);
            Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)new ResourceLocation(MOD_ID, "dark_coven_leg_processor"), DARK_COVEN_LEG_PROCESSOR);
            Registry.func_218322_a((Registry)Registry.field_218364_E, (ResourceLocation)new ResourceLocation(MOD_ID, "mangrove_tree_leg_processor"), MANGROVE_TREE_LEG_PROCESSOR);
            HexereiPacketHandler.register();
        });
    }

    public void registerCommands(RegisterCommandsEvent event) {
        PigeonReviveCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.QUICKSILVER_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.QUICKSILVER_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModFluids.QUICKSILVER_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.BLOOD_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModFluids.BLOOD_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.TALLOW_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)ModFluids.TALLOW_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModFluids.TALLOW_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_DOOR.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_TRAPDOOR.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_TRAPDOOR.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILLOW_DOOR.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILLOW_TRAPDOOR.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILLOW_LEAVES.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_ORB.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_LARGE_RING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CRYSTAL_BALL_SMALL_RING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HERB_JAR.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.HERB_DRYING_RACK_FULL.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MAHOGANY_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WILLOW_SAPLING.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MANDRAKE_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.BELLADONNA_FLOWER.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.MUGWORT_BUSH.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.YELLOW_DOCK_BUSH.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.CANDELABRA.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SAGE.get()), (RenderType)RenderType.func_228643_e_());
            RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.LILY_PAD_BLOCK.get()), (RenderType)RenderType.func_228643_e_());
            ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.MIXING_CAULDRON_CONTAINER.get()), MixingCauldronScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.COFFER_CONTAINER.get()), CofferScreen::new);
            ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.HERB_JAR_CONTAINER.get()), HerbJarScreen::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.MIXING_CAULDRON_TILE.get()), MixingCauldronRenderer::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.COFFER_TILE.get()), CofferRenderer::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.HERB_JAR_TILE.get()), HerbJarRenderer::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.CRYSTAL_BALL_TILE.get()), CrystalBallRenderer::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.BOOK_OF_SHADOWS_ALTAR_TILE.get()), BookOfShadowsAltarRenderer::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.CANDLE_TILE.get()), CandleRenderer::new);
            ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get()), CandleDipperRenderer::new);
        });
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.BROOM.get()), BroomRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.BUFF_ZOMBIE.get()), BuffZombieRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntityTypes.PIGEON.get()), PigeonRenderer::new);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    public static String sId(String name) {
        return "hexerei:" + name;
    }

    public static ResourceLocation asResource(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

