/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.criteria;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class SafeStructureLocatePredicate {
    @Nullable
    private final Structure<?> structure;

    public SafeStructureLocatePredicate(@Nullable Structure<?> structure) {
        this.structure = structure;
    }

    public boolean test(ServerWorld world, double x, double y, double z) {
        return this.test(world, (float)x, (float)y, (float)z);
    }

    public boolean test(ServerWorld world, float x, float y, float z) {
        BlockPos blockpos = new BlockPos((double)x, (double)y, (double)z);
        return this.structure != null && world.func_195588_v(blockpos) && world.func_241112_a_().func_235010_a_(blockpos, true, this.structure).func_75069_d();
    }

    public JsonElement serialize() {
        JsonObject jsonobject = new JsonObject();
        if (this.structure != null) {
            jsonobject.addProperty("feature", this.structure.func_143025_a());
        }
        return jsonobject;
    }

    public static SafeStructureLocatePredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)element, (String)"location");
            Structure structure = jsonobject.has("feature") ? (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonobject, (String)"feature"))) : null;
            return new SafeStructureLocatePredicate(structure);
        }
        return new SafeStructureLocatePredicate(null);
    }
}

