/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.core.data.server;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.minecraftabnormals.buzzier_bees.common.advancement.ImprovedEmptyTrigger;
import com.minecraftabnormals.buzzier_bees.core.other.BBCriteriaTriggers;
import com.minecraftabnormals.buzzier_bees.core.registry.BBItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BBAdvancementProvider
extends AdvancementProvider {
    private final Path PATH;
    public static final Logger LOGGER = LogManager.getLogger();

    public BBAdvancementProvider(DataGenerator generator) {
        super(generator);
        this.PATH = generator.func_200391_b();
    }

    public void func_200398_a(DirectoryCache cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path1 = BBAdvancementProvider.getPath(this.PATH, advancement);
            try {
                IDataProvider.func_218426_a((Gson)new GsonBuilder().setPrettyPrinting().create(), (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new BBAdvancements().accept(consumer);
    }

    private static Path getPath(Path path, Advancement advancement) {
        return path.resolve("data/" + advancement.func_192067_g().func_110624_b() + "/advancements/" + advancement.func_192067_g().func_110623_a() + ".json");
    }

    public static class BBAdvancements
    implements Consumer<Consumer<Advancement>> {
        @Override
        public void accept(Consumer<Advancement> consumer) {
            BBAdvancements.createAdvancement("four_leaf_clover", "adventure", new ResourceLocation("adventure/sleep_in_bed"), (IItemProvider)BBItems.FOUR_LEAF_CLOVER.get(), FrameType.CHALLENGE, true, true, false).func_200275_a("four_leaf_clover", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{(IItemProvider)BBItems.FOUR_LEAF_CLOVER.get()})).func_203904_a(consumer, "buzzier_bees:adventure/four_leaf_clover");
            BBAdvancements.createCureAdvancement("use_glazed_porkchop", (IItemProvider)BBItems.GLAZED_PORKCHOP.get(), BBCriteriaTriggers.GLAZED_PORKCHOP_CURE, consumer);
            BBAdvancements.createCureAdvancement("use_honey_bread", (IItemProvider)BBItems.HONEY_BREAD.get(), BBCriteriaTriggers.HONEY_BREAD_CURE, consumer);
            BBAdvancements.createCureAdvancement("use_honey_apple", (IItemProvider)BBItems.HONEY_APPLE.get(), BBCriteriaTriggers.HONEY_APPLE_CURE, consumer);
        }

        private static Advancement.Builder createAdvancement(String name, String category, ResourceLocation parent, IItemProvider icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.func_200278_a().func_203905_a(Advancement.Builder.func_200278_a().func_192056_a(parent)).func_203902_a(icon, (ITextComponent)new TranslationTextComponent("advancements.buzzier_bees." + category + "." + name + ".title"), (ITextComponent)new TranslationTextComponent("advancements.buzzier_bees." + category + "." + name + ".description"), null, frame, showToast, announceToChat, hidden);
        }

        private static void createCureAdvancement(String name, IItemProvider item, ImprovedEmptyTrigger trigger, Consumer<Advancement> consumer) {
            BBAdvancements.createAdvancement(name, "husbandry", new ResourceLocation("husbandry/safely_harvest_honey"), item, FrameType.TASK, true, true, false).func_200275_a(name, (ICriterionInstance)new ImprovedEmptyTrigger.Instance(trigger.func_192163_a())).func_203904_a(consumer, "buzzier_bees:husbandry/" + name);
        }
    }
}

