/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.common.entities;

import com.minecraftabnormals.buzzier_bees.common.entities.goals.bear.BearAttackPlayerGoal;
import com.minecraftabnormals.buzzier_bees.common.entities.goals.bear.BearHurtByTargetGoal;
import com.minecraftabnormals.buzzier_bees.common.entities.goals.bear.BearMeleeAttackGoal;
import com.minecraftabnormals.buzzier_bees.common.entities.goals.bear.BearPanicGoal;
import com.minecraftabnormals.buzzier_bees.core.other.tags.BBItemTags;
import com.minecraftabnormals.buzzier_bees.core.registry.BBEntities;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class GrizzlyBearEntity
extends AnimalEntity {
    private static final DataParameter<Boolean> EATING = EntityDataManager.func_187226_a(GrizzlyBearEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<ItemEntity> TRUSTED_TARGET_SELECTOR = entity -> !entity.func_174874_s() && entity.func_70089_S();
    private int warningSoundTicks;
    public int eatTicks;

    public GrizzlyBearEntity(EntityType<? extends GrizzlyBearEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_98053_h(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BearMeleeAttackGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BearPanicGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new FindItemsGoal());
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new BearHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new BearAttackPlayerGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, FoxEntity.class, 10, true, true, null));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233823_f_, 6.0);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(BBItemTags.GRIZZLY_BEAR_FOOD);
    }

    protected SoundEvent func_184639_G() {
        return this.func_70631_g_() ? SoundEvents.field_190027_es : SoundEvents.field_190026_er;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_190029_eu;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_190028_et;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    public void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(SoundEvents.field_190031_ew, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EATING, (Object)false);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return (AgeableEntity)((EntityType)BBEntities.GRIZZLY_BEAR.get()).func_200721_a((World)world);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_205157_eZ) {
            this.setEating(true);
        } else if (stack.func_77973_b() == Items.field_205158_fa) {
            this.setEating(false);
        }
        return super.func_230254_b_(player, hand);
    }

    private boolean canEatItem(ItemStack itemStackIn) {
        return itemStackIn.func_77973_b().func_219971_r() && this.func_70638_az() == null && this.field_70122_E;
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d((ItemStack)itemstackIn);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(itemstackIn);
    }

    public boolean func_175448_a(ItemStack stack) {
        Item item = stack.func_77973_b();
        ItemStack itemstack = this.func_184582_a(EquipmentSlotType.MAINHAND);
        return itemstack.func_190926_b() || this.eatTicks > 0 && item.func_219971_r() && !itemstack.func_77973_b().func_219971_r();
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    private void spawnItem(ItemStack stackIn) {
        ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), stackIn);
        this.field_70170_p.func_217376_c((Entity)itementity);
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (this.func_175448_a(itemstack)) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                this.spawnItem(itemstack.func_77979_a(i - 1));
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
            this.eatTicks = 0;
        }
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            ++this.eatTicks;
            ItemStack stack = this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (this.canEatItem(stack)) {
                if (this.eatTicks > 600) {
                    ItemStack returnStack = stack.func_77950_b(this.field_70170_p, (LivingEntity)this);
                    if (!returnStack.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.MAINHAND, returnStack);
                    }
                    this.eatTicks = 0;
                    this.setEating(false);
                } else if (this.eatTicks > 560 && this.field_70146_Z.nextFloat() < 0.1f) {
                    this.setEating(true);
                    this.func_184185_a(this.func_213353_d(stack), 1.0f, 1.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)45);
                }
            }
        }
        super.func_70636_d();
    }

    public boolean isEating() {
        return (Boolean)this.field_70180_af.func_187225_a(EATING);
    }

    public void setEating(boolean eating) {
        this.field_70180_af.func_187227_b(EATING, (Object)eating);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(Attributes.field_233823_f_).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    protected float func_189749_co() {
        return 0.98f;
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (spawnDataIn == null) {
            spawnDataIn = new AgeableEntity.AgeableData(1.0f);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    class FindItemsGoal
    extends Goal {
        public FindItemsGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (!GrizzlyBearEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b()) {
                return false;
            }
            if (GrizzlyBearEntity.this.func_70638_az() == null && GrizzlyBearEntity.this.func_70643_av() == null) {
                if (GrizzlyBearEntity.this.func_70681_au().nextInt(10) != 0) {
                    return false;
                }
                List list = GrizzlyBearEntity.this.field_70170_p.func_175647_a(ItemEntity.class, GrizzlyBearEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
                return !list.isEmpty() && GrizzlyBearEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
            }
            return false;
        }

        public void func_75246_d() {
            List list = GrizzlyBearEntity.this.field_70170_p.func_175647_a(ItemEntity.class, GrizzlyBearEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
            ItemStack itemstack = GrizzlyBearEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (itemstack.func_190926_b() && !list.isEmpty()) {
                GrizzlyBearEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }

        public void func_75249_e() {
            List list = GrizzlyBearEntity.this.field_70170_p.func_175647_a(ItemEntity.class, GrizzlyBearEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), TRUSTED_TARGET_SELECTOR);
            if (!list.isEmpty()) {
                GrizzlyBearEntity.this.func_70661_as().func_75497_a((Entity)list.get(0), (double)1.2f);
            }
        }
    }
}

