/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.CustomPickupOverrideHandler;
import tschipp.carryon.common.handler.ListHandler;
import tschipp.carryon.common.handler.PickupHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.common.scripting.ScriptReader;
import tschipp.carryon.network.client.CarrySlotPacket;
import tschipp.carryon.network.client.ScriptReloadPacket;

@Mod.EventBusSubscriber(modid="carryon")
public class ItemEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!stack.func_190926_b() && stack.func_77973_b() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack)) {
            String command;
            CarryOnOverride override;
            player.getPersistentData().func_82580_o("carrySlot");
            event.setUseBlock(Event.Result.DENY);
            if (!player.field_70170_p.field_72995_K && (override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandPlace()) != null && !command.isEmpty()) {
                player.func_184102_h().func_195571_aL().func_197059_a(player.func_184102_h().func_195573_aM(), "/execute as " + player.func_146103_bH().getName() + " run " + command);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onItemDropped(EntityJoinWorldEvent event) {
        ItemEntity eitem;
        ItemStack stack;
        Item item;
        Entity e = event.getEntity();
        World world = event.getWorld();
        if (e instanceof ItemEntity && (item = (stack = (eitem = (ItemEntity)e).func_92059_d()).func_77973_b()) == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack)) {
            BlockPos pos;
            BlockPos finalPos = pos = eitem.func_233580_cy_();
            DirectionalPlaceContext context = new DirectionalPlaceContext(world, pos, Direction.DOWN, stack, Direction.UP);
            if (!world.func_180495_p(pos).func_196953_a((BlockItemUseContext)context) || !context.func_196011_b()) {
                for (Direction facing : Direction.values()) {
                    BlockPos offsetPos = pos.func_177972_a(facing);
                    DirectionalPlaceContext newContext = new DirectionalPlaceContext(world, offsetPos, Direction.DOWN, stack, Direction.UP);
                    if (!world.func_180495_p(offsetPos).func_196953_a((BlockItemUseContext)newContext) || !newContext.func_196011_b()) continue;
                    finalPos = offsetPos;
                    break;
                }
            }
            world.func_175656_a(finalPos, ItemCarryonBlock.getBlockState(stack));
            TileEntity tile = world.func_175625_s(finalPos);
            if (tile != null) {
                tile.deserializeNBT(ItemCarryonBlock.getTileData(stack));
                tile.func_174878_a(finalPos);
            }
            ItemCarryonBlock.clearTileData(stack);
            eitem.func_92058_a(ItemStack.field_190927_a);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof PlayerEntity) {
            PlayerEntity player = event.getPlayer();
            World world = player.func_130014_f_();
            ItemStack carried = player.func_184614_ca();
            if (!carried.func_190926_b() && carried.func_77973_b() == RegistrationHandler.itemTile || carried.func_77973_b() == RegistrationHandler.itemEntity) {
                if (carried.func_77973_b() == RegistrationHandler.itemTile) {
                    CarryOnOverride override = ScriptChecker.inspectBlock(ItemCarryonBlock.getBlockState(carried), world, player.func_233580_cy_(), ItemCarryonBlock.getTileData(carried));
                    if (override != null) {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()));
                    } else {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()));
                    }
                } else {
                    CarryOnOverride override = ScriptChecker.inspectEntity(ItemCarryonEntity.getEntity(carried, world));
                    if (override != null) {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()));
                    } else {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()));
                    }
                }
            }
        }
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new ScriptReloadPacket(ScriptReader.OVERRIDES.values()));
        }
    }

    @SubscribeEvent
    public void serverLoad(RegisterCommandsEvent event) {
        CommandCarryOn.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        CustomPickupOverrideHandler.initPickupOverrides();
    }

    @SubscribeEvent
    public void reloadTags(TagsUpdatedEvent event) {
        ListHandler.initConfigLists();
        CustomPickupOverrideHandler.initPickupOverrides();
    }

    @SubscribeEvent
    public void onEntityStartTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        PlayerEntity tracker = event.getPlayer();
        if (e instanceof PlayerEntity && tracker instanceof ServerPlayerEntity) {
            PlayerEntity player = (PlayerEntity)e;
            World world = player.func_130014_f_();
            ItemStack carried = player.func_184614_ca();
            if (!carried.func_190926_b() && carried.func_77973_b() == RegistrationHandler.itemTile || carried.func_77973_b() == RegistrationHandler.itemEntity) {
                if (carried.func_77973_b() == RegistrationHandler.itemTile) {
                    CarryOnOverride override = ScriptChecker.inspectBlock(ItemCarryonBlock.getBlockState(carried), world, player.func_233580_cy_(), ItemCarryonBlock.getTileData(carried));
                    if (override != null) {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)tracker), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()));
                    } else {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)tracker), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()));
                    }
                } else {
                    CarryOnOverride override = ScriptChecker.inspectEntity(ItemCarryonEntity.getEntity(carried, world));
                    if (override != null) {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)tracker), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y(), override.hashCode()));
                    } else {
                        CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)tracker), (Object)new CarrySlotPacket(player.field_71071_by.field_70461_c, player.func_145782_y()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void harvestSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack;
        PlayerEntity player = event.getPlayer();
        if (!(player == null || ((Boolean)Configs.Settings.hitWhileCarrying.get()).booleanValue() || (stack = player.func_184614_ca()).func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity)) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!(stack.func_190926_b() || ((Boolean)Configs.Settings.hitWhileCarrying.get()).booleanValue() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void harvestSpeed(BlockEvent.BreakEvent event) {
        ItemStack stack;
        PlayerEntity player = event.getPlayer();
        if (!(player == null || ((Boolean)Configs.Settings.hitWhileCarrying.get()).booleanValue() || (stack = player.func_184614_ca()).func_190926_b() || stack.func_77973_b() != RegistrationHandler.itemTile && stack.func_77973_b() != RegistrationHandler.itemEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void playerAttack(LivingAttackEvent event) {
        PlayerEntity player;
        ItemStack stack;
        LivingEntity eliving = event.getEntityLiving();
        if (eliving instanceof PlayerEntity && ((Boolean)Configs.Settings.dropCarriedWhenHit.get()).booleanValue() && !(stack = (player = (PlayerEntity)eliving).func_184614_ca()).func_190926_b() && (stack.func_77973_b() == RegistrationHandler.itemTile || stack.func_77973_b() == RegistrationHandler.itemEntity) && !player.field_70170_p.field_72995_K) {
            player.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            ItemEntity item = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), stack);
            ItemEvents.sendPacket(player, 9, 0);
            player.field_70170_p.func_217376_c((Entity)item);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        if (event.isCanceled()) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            BlockState state = world.func_180495_p(pos);
            if (main.func_190926_b() && off.func_190926_b() && CarryOnKeybinds.isKeyPressed(player)) {
                ItemStack stack = new ItemStack((IItemProvider)RegistrationHandler.itemTile);
                TileEntity te = world.func_175625_s(pos);
                if (PickupHandler.canPlayerPickUpBlock((ServerPlayerEntity)player, te, world, pos)) {
                    player.func_71053_j();
                    world.func_217379_c(1010, pos, 0);
                    if (ItemCarryonBlock.storeTileData(te, world, pos, state, stack)) {
                        String command;
                        BlockState statee = world.func_180495_p(pos);
                        CompoundNBT tag = new CompoundNBT();
                        tag = world.func_175625_s(pos) != null ? world.func_175625_s(pos).func_189515_b(tag) : new CompoundNBT();
                        CarryOnOverride override = ScriptChecker.inspectBlock(state, world, pos, tag);
                        int overrideHash = 0;
                        if (override != null) {
                            overrideHash = override.hashCode();
                        }
                        boolean success = false;
                        try {
                            ItemEvents.sendPacket(player, player.field_71071_by.field_70461_c, overrideHash);
                            world.func_175713_t(pos);
                            world.func_217377_a(pos, false);
                            player.func_184611_a(Hand.MAIN_HAND, stack);
                            event.setUseBlock(Event.Result.DENY);
                            event.setUseItem(Event.Result.DENY);
                            event.setCanceled(true);
                            success = true;
                        }
                        catch (Exception e) {
                            try {
                                ItemEvents.sendPacket(player, player.field_71071_by.field_70461_c, overrideHash);
                                ItemEvents.emptyTileEntity(te);
                                world.func_217377_a(pos, false);
                                player.func_184611_a(Hand.MAIN_HAND, stack);
                                event.setUseBlock(Event.Result.DENY);
                                event.setUseItem(Event.Result.DENY);
                                event.setCanceled(true);
                                success = true;
                            }
                            catch (Exception ex) {
                                ItemEvents.sendPacket(player, 9, 0);
                                world.func_175656_a(pos, statee);
                                if (!tag.isEmpty()) {
                                    TileEntity.func_235657_b_((BlockState)statee, (CompoundNBT)tag);
                                }
                                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Error detected. Cannot pick up block."), false);
                                StringTextComponent s = new StringTextComponent(TextFormatting.GOLD + "here");
                                s.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Tschipp/CarryOn/issues"));
                                player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Please report this error ").func_230529_a_((ITextComponent)s), false);
                            }
                        }
                        if (success && override != null && (command = override.getCommandInit()) != null) {
                            player.func_184102_h().func_195571_aL().func_197059_a(player.func_184102_h().func_195573_aM(), "/execute as " + player.func_146103_bH().getName() + " run " + command);
                        }
                    }
                }
            }
        }
    }

    public static void emptyTileEntity(TileEntity te) {
        if (te != null) {
            for (Direction facing : Direction.values()) {
                LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
                itemHandler.ifPresent(handler -> {
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        handler.extractItem(i, 64, false);
                    }
                });
            }
            LazyOptional itemHandler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            itemHandler.ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    handler.extractItem(i, 64, false);
                }
            });
            if (te instanceof IInventory) {
                IInventory inv = (IInventory)te;
                inv.func_174888_l();
            }
            if (te instanceof IItemHandler) {
                IItemHandler itemHandler1 = (IItemHandler)te;
                for (int i = 0; i < itemHandler1.getSlots(); ++i) {
                    itemHandler1.extractItem(i, 64, false);
                }
            }
            te.func_70296_d();
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.Clone event) {
        boolean wasCarrying;
        PlayerEntity original = event.getOriginal();
        PlayerEntity player = event.getPlayer();
        boolean wasDead = event.isWasDeath();
        GameRules rules = player.field_70170_p.func_82736_K();
        boolean keepInv = rules.func_223586_b(GameRules.field_223600_c);
        boolean bl = wasCarrying = player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)RegistrationHandler.itemTile)) || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)RegistrationHandler.itemEntity));
        if ((!wasDead || keepInv) && wasCarrying) {
            int carrySlot = original.field_71071_by.field_70461_c;
            ItemStack stack = player.field_71071_by.func_70304_b(carrySlot);
            World world = player.field_70170_p;
            ItemEntity item = new ItemEntity(world, 0.0, 0.0, 0.0);
            item.func_92058_a(stack);
            BlockPos pos = null;
            Optional bedpos = original.func_213374_dv();
            if (bedpos.isPresent()) {
                pos = (BlockPos)bedpos.get();
            }
            if (pos == null) {
                pos = player.func_233580_cy_();
            }
            item.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            world.func_217376_c((Entity)item);
        }
    }

    @SubscribeEvent
    public void dropNonHotbarItems(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!entity.field_70170_p.field_72995_K) {
                String command;
                CarryOnOverride override;
                boolean hasCarried = player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)RegistrationHandler.itemTile)) || player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)RegistrationHandler.itemEntity));
                ItemStack inHand = player.func_184614_ca();
                if (hasCarried && inHand.func_77973_b() != RegistrationHandler.itemTile && inHand.func_77973_b() != RegistrationHandler.itemEntity && player.func_82147_ab() == 0) {
                    ItemStack dropped;
                    int slotBlock = this.getSlot(player, RegistrationHandler.itemTile);
                    int slotEntity = this.getSlot(player, RegistrationHandler.itemEntity);
                    ItemEntity item = null;
                    if (slotBlock != -1) {
                        dropped = player.field_71071_by.func_70304_b(slotBlock);
                        item = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), dropped);
                    }
                    if (slotEntity != -1) {
                        dropped = player.field_71071_by.func_70304_b(slotEntity);
                        item = new ItemEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), dropped);
                    }
                    if (item != null) {
                        player.field_70170_p.func_217376_c(item);
                        ItemEvents.sendPacket(player, 9, 0);
                    }
                }
                if ((override = ScriptChecker.getOverride(player)) != null && (command = override.getCommandLoop()) != null) {
                    player.func_184102_h().func_195571_aL().func_197059_a(player.func_184102_h().func_195573_aM(), "/execute as " + player.func_146103_bH().getName() + " run " + command);
                }
            }
        }
    }

    public int getSlot(PlayerEntity player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != item) continue;
            return i;
        }
        return -1;
    }

    public static void sendPacket(PlayerEntity player, int currentItem, int hash) {
        if (player instanceof ServerPlayerEntity) {
            CarryOn.network.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 128.0, player.field_70170_p.func_234923_W_())), (Object)new CarrySlotPacket(currentItem, player.func_145782_y(), hash));
            CarryOn.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new CarrySlotPacket(currentItem, player.func_145782_y(), hash));
            if (currentItem >= 9) {
                player.getPersistentData().func_82580_o("carrySlot");
                player.getPersistentData().func_82580_o("overrideKey");
            } else {
                player.getPersistentData().func_74768_a("carrySlot", currentItem);
                if (hash != 0) {
                    ScriptChecker.setCarryOnOverride(player, hash);
                }
            }
        }
    }
}

