/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.network.server;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.client.base.IRecipesWidget;
import top.theillusivec4.polymorph.client.recipe.RecipesWidget;
import top.theillusivec4.polymorph.common.capability.PolymorphCapabilities;
import top.theillusivec4.polymorph.common.network.server.SPacketBlockEntityRecipeSync;
import top.theillusivec4.polymorph.common.network.server.SPacketHighlightRecipe;
import top.theillusivec4.polymorph.common.network.server.SPacketPlayerRecipeSync;
import top.theillusivec4.polymorph.common.network.server.SPacketRecipesList;

public class ClientPacketHandler {
    public static void handle(SPacketPlayerRecipeSync pPacket) {
        ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayerEntity != null) {
            PolymorphApi.common().getRecipeData((PlayerEntity)clientPlayerEntity).ifPresent(recipeData -> {
                recipeData.setRecipesList(pPacket.getRecipeList());
                clientPlayerEntity.field_70170_p.func_199532_z().func_215367_a(pPacket.getSelected()).ifPresent(recipeData::setSelectedRecipe);
            });
        }
    }

    public static void handle(SPacketBlockEntityRecipeSync pPacket) {
        TileEntity blockEntity;
        ClientWorld level = Minecraft.func_71410_x().field_71441_e;
        if (level != null && (blockEntity = level.func_175625_s(pPacket.getBlockPos())) != null) {
            PolymorphCapabilities.getRecipeData(blockEntity).ifPresent(recipeData -> level.func_199532_z().func_215367_a(pPacket.getSelected()).ifPresent(recipeData::setSelectedRecipe));
        }
    }

    public static void handle(SPacketRecipesList pPacket) {
        ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayerEntity != null) {
            Optional<IRecipesWidget> maybeWidget = RecipesWidget.get();
            maybeWidget.ifPresent(widget -> widget.setRecipesList(pPacket.getRecipeList(), pPacket.getSelected()));
            if (!maybeWidget.isPresent()) {
                RecipesWidget.enqueueRecipesList(pPacket.getRecipeList(), pPacket.getSelected());
            }
        }
    }

    public static void handle(SPacketHighlightRecipe pPacket) {
        ClientPlayerEntity clientPlayerEntity = Minecraft.func_71410_x().field_71439_g;
        if (clientPlayerEntity != null) {
            RecipesWidget.get().ifPresent(widget -> widget.highlightRecipe(pPacket.getRecipe()));
        }
    }
}

