/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.integration.cyclic;

import com.lothrazar.cyclic.block.crafter.ContainerCrafter;
import com.lothrazar.cyclic.block.crafter.ScreenCrafter;
import com.lothrazar.cyclic.block.crafter.TileCrafter;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.polymorph.api.PolymorphApi;
import top.theillusivec4.polymorph.api.common.base.IPolymorphCommon;
import top.theillusivec4.polymorph.common.crafting.RecipeSelection;
import top.theillusivec4.polymorph.common.integration.AbstractCompatibilityModule;
import top.theillusivec4.polymorph.common.integration.cyclic.CrafterRecipesWidget;
import top.theillusivec4.polymorph.common.integration.cyclic.TileCrafterRecipeData;
import top.theillusivec4.polymorph.mixin.integration.cyclic.AccessorContainerCrafter;
import top.theillusivec4.polymorph.mixin.integration.cyclic.AccessorTileCrafter;

public class CyclicModule
extends AbstractCompatibilityModule {
    @Override
    public void setup() {
        IPolymorphCommon commonApi = PolymorphApi.common();
        commonApi.registerTileEntity2RecipeData(tileEntity -> {
            if (tileEntity instanceof TileCrafter) {
                return new TileCrafterRecipeData((TileCrafter)tileEntity);
            }
            return null;
        });
        commonApi.registerContainer2TileEntity(container -> {
            if (container instanceof ContainerCrafter) {
                return ((AccessorContainerCrafter)container).getTile();
            }
            return null;
        });
    }

    @Override
    public void clientSetup() {
        PolymorphApi.client().registerWidget(containerScreen -> {
            if (containerScreen instanceof ScreenCrafter && containerScreen.func_212873_a_() instanceof ContainerCrafter) {
                ContainerCrafter containerCrafter = (ContainerCrafter)containerScreen.func_212873_a_();
                return new CrafterRecipesWidget(containerScreen, containerCrafter);
            }
            return null;
        });
    }

    @Override
    public boolean openContainer(Container container, ServerPlayerEntity serverPlayerEntity) {
        if (container instanceof CraftingBagContainer) {
            PolymorphApi.common().getRecipeData((PlayerEntity)serverPlayerEntity).ifPresent(recipeData -> container.func_75130_a(null));
            return true;
        }
        return false;
    }

    @Override
    public boolean selectRecipe(TileEntity tileEntity, IRecipe<?> recipe) {
        if (tileEntity instanceof TileCrafter) {
            AccessorTileCrafter tileCrafter = (AccessorTileCrafter)tileEntity;
            tileCrafter.setLastValidRecipe(recipe);
            tileCrafter.setRecipeOutput(recipe.func_77571_b());
            LazyOptional<IItemHandler> preview = tileCrafter.getPreview();
            if (preview != null) {
                tileCrafter.callSetPreviewSlot((IItemHandler)preview.orElse(null), recipe.func_77571_b());
            }
            return true;
        }
        return false;
    }

    public static <T extends IRecipe<C>, C extends IInventory> Optional<T> getRecipe(ArrayList<ItemStack> stacks, World worldIn, TileEntity te) {
        if (worldIn != null && worldIn.func_73046_m() != null) {
            CraftingInventory craftingInventory = new CraftingInventory((Container)new FakeContainer(ContainerType.field_221518_l, 18291239), 3, 3);
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int indexInArray = i + j * 3;
                    ItemStack stack = stacks.get(indexInArray);
                    craftingInventory.func_70299_a(indexInArray, stack.func_77946_l());
                }
            }
            return RecipeSelection.getTileEntityRecipe(IRecipeType.field_222149_a, craftingInventory, worldIn, te);
        }
        return Optional.empty();
    }

    private static class FakeContainer
    extends Container {
        protected FakeContainer(ContainerType<?> type, int id) {
            super(type, id);
        }

        public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
            return true;
        }
    }
}

