/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.common.capability;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;
import top.theillusivec4.polymorph.api.common.capability.ITileEntityRecipeData;
import top.theillusivec4.polymorph.common.capability.AbstractRecipeData;

public abstract class AbstractTileEntityRecipeData<E extends TileEntity>
extends AbstractRecipeData<TileEntity>
implements ITileEntityRecipeData {
    private final Map<UUID, ServerPlayerEntity> listeners = new HashMap<UUID, ServerPlayerEntity>();
    private NonNullList<Item> lastInput = NonNullList.func_191196_a();

    public AbstractTileEntityRecipeData(E pOwner) {
        super(pOwner);
    }

    protected abstract NonNullList<ItemStack> getInput();

    @Override
    public void tick() {
        boolean changed = false;
        NonNullList<ItemStack> currentInput = this.getInput();
        this.lastInput = this.validateList(this.lastInput, currentInput.size());
        for (int i = 0; i < currentInput.size(); ++i) {
            Item lastItem = (Item)this.lastInput.get(i);
            ItemStack currentStack = (ItemStack)currentInput.get(i);
            Item item = Items.field_190931_a;
            if (currentStack.func_190916_E() > 0) {
                item = currentStack.func_77973_b();
            }
            if (lastItem != currentStack.func_77973_b()) {
                changed = true;
            }
            this.lastInput.set(i, (Object)item);
        }
        if (changed) {
            this.sendRecipesListToListeners(this.isFailing() || this.isEmpty());
        }
    }

    @Override
    public void addListener(ServerPlayerEntity serverPlayer) {
        this.listeners.put(serverPlayer.func_110124_au(), serverPlayer);
    }

    @Override
    public void removeListener(ServerPlayerEntity serverPlayer) {
        this.listeners.remove(serverPlayer.func_110124_au());
    }

    private NonNullList<Item> validateList(NonNullList<Item> pList, int pSize) {
        if (pList.size() == pSize) {
            return pList;
        }
        NonNullList resized = NonNullList.func_191197_a((int)pSize, (Object)Items.field_190931_a);
        for (int i = 0; i < Math.min(resized.size(), pList.size()); ++i) {
            resized.set(i, pList.get(i));
        }
        return resized;
    }

    @Override
    public Set<ServerPlayerEntity> getListeners() {
        return new HashSet<ServerPlayerEntity>(this.listeners.values());
    }

    @Override
    public E getOwner() {
        return (E)((TileEntity)super.getOwner());
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.getInput()) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Pair<SortedSet<IRecipePair>, ResourceLocation> getPacketData() {
        return new Pair(this.getRecipesList(), null);
    }

    @Override
    public boolean isEmpty(IInventory pInventory) {
        return this.isEmpty();
    }
}

