/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.polymorph.api.client.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.polymorph.api.client.base.IRecipesWidget;
import top.theillusivec4.polymorph.api.client.widget.OpenSelectionButton;
import top.theillusivec4.polymorph.api.client.widget.SelectionWidget;
import top.theillusivec4.polymorph.api.common.base.IRecipePair;

public abstract class AbstractRecipesWidget
implements IRecipesWidget {
    public static final ResourceLocation WIDGETS = new ResourceLocation("polymorph", "textures/gui/widgets.png");
    public static final int BUTTON_X_OFFSET = 0;
    public static final int BUTTON_Y_OFFSET = -22;
    public static final int WIDGET_X_OFFSET = -4;
    public static final int WIDGET_Y_OFFSET = -26;
    protected final ContainerScreen<?> containerScreen;
    protected final int xOffset;
    protected final int yOffset;
    protected SelectionWidget selectionWidget;
    protected OpenSelectionButton openButton;

    public AbstractRecipesWidget(ContainerScreen<?> pContainerScreen, int pXOffset, int pYOffset) {
        this.containerScreen = pContainerScreen;
        this.xOffset = pXOffset;
        this.yOffset = pYOffset;
    }

    public AbstractRecipesWidget(ContainerScreen<?> pContainerScreen) {
        this(pContainerScreen, -4, -26);
    }

    @Override
    public void initChildWidgets() {
        int x = this.containerScreen.getGuiLeft() + this.getXPos();
        int y = this.containerScreen.getGuiTop() + this.getYPos();
        this.selectionWidget = new SelectionWidget(x + this.xOffset, y + this.yOffset, this.getXPos() + this.xOffset, this.getYPos() + this.yOffset, this::selectRecipe, this.containerScreen);
        this.openButton = new OpenSelectionButton(this.containerScreen, this.getXPos(), this.getYPos(), clickWidget -> this.selectionWidget.setActive(!this.selectionWidget.isActive()));
        this.openButton.field_230694_p_ = this.selectionWidget.getOutputWidgets().size() > 1;
    }

    protected void resetWidgetOffsets() {
        int x = this.getXPos();
        int y = this.getYPos();
        this.selectionWidget.setOffsets(x + this.xOffset, y + this.yOffset);
        this.openButton.setOffsets(x, y);
    }

    @Override
    public abstract void selectRecipe(ResourceLocation var1);

    @Override
    public SelectionWidget getSelectionWidget() {
        return this.selectionWidget;
    }

    @Override
    public void highlightRecipe(ResourceLocation pResourceLocation) {
        this.selectionWidget.highlightButton(pResourceLocation);
    }

    @Override
    public void setRecipesList(Set<IRecipePair> pRecipesList, ResourceLocation pSelected) {
        TreeSet<IRecipePair> sorted = new TreeSet<IRecipePair>(pRecipesList);
        this.selectionWidget.setRecipeList(sorted);
        boolean bl = this.openButton.field_230694_p_ = pRecipesList.size() > 1;
        if (pSelected != null) {
            this.highlightRecipe(pSelected);
        }
    }

    @Override
    public void render(MatrixStack pMatrixStack, int pMouseX, int pMouseY, float pRenderPartialTicks) {
        this.selectionWidget.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pRenderPartialTicks);
        this.openButton.func_230430_a_(pMatrixStack, pMouseX, pMouseY, pRenderPartialTicks);
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.openButton.func_231044_a_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (this.selectionWidget.func_231044_a_(pMouseX, pMouseY, pButton)) {
            this.selectionWidget.setActive(false);
            return true;
        }
        if (this.selectionWidget.isActive()) {
            if (!this.openButton.func_231044_a_(pMouseX, pMouseY, pButton)) {
                this.selectionWidget.setActive(false);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getXPos() {
        return this.getOutputSlot().field_75223_e + 0;
    }

    @Override
    public int getYPos() {
        return this.getOutputSlot().field_75221_f + -22;
    }
}

