/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.tileentity;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.EventHandler;
import xfacthd.framedblocks.common.util.ServerConfig;
import xfacthd.framedblocks.common.util.Utils;

public class FramedTileEntity
extends TileEntity {
    public static final TranslationTextComponent MSG_BLACKLISTED = new TranslationTextComponent("msg.framedblocks.blacklisted");
    public static final TranslationTextComponent MSG_TILE_ENTITY = new TranslationTextComponent("msg.framedblocks.tile_entity");
    private final FramedBlockData modelData = new FramedBlockData(true);
    private ItemStack camoStack = ItemStack.field_190927_a;
    private BlockState camoState = Blocks.field_150350_a.func_176223_P();
    private boolean glowing = false;
    private boolean intangible = false;
    private boolean recheckStates = false;

    public FramedTileEntity() {
        this((TileEntityType)FBContent.tileTypeFramedBlock.get());
    }

    protected FramedTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public ActionResultType handleInteraction(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        BlockState camo = this.getCamoState(hit);
        if (!camo.func_196958_f() && !(camo.func_177230_c() instanceof FlowingFluidBlock) && stack.func_77973_b() == FBContent.itemFramedHammer.get()) {
            return this.clearBlockCamo(player, hit);
        }
        if (!camo.func_196958_f() && camo.func_177230_c() instanceof FlowingFluidBlock && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.PASS;
        }
        if (camo.func_196958_f() && stack.func_77973_b() instanceof BlockItem) {
            return this.setBlockCamo(player, stack, hit);
        }
        if (camo.func_196958_f() && stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).isPresent()) {
            return ActionResultType.PASS;
        }
        if (stack.func_77973_b().func_206844_a((ITag)Tags.Items.DUSTS_GLOWSTONE) && !this.glowing) {
            if (!this.field_145850_b.func_201670_d()) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                int light = this.getLightValue();
                this.glowing = true;
                if (this.updateDynamicStates(false, true)) {
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                }
                boolean lightUpdate = this.getLightValue() != light;
                this.func_70296_d();
                if (lightUpdate) {
                    this.doLightUpdate();
                }
            }
            return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        if (!camo.func_196958_f() && !player.func_225608_bj_() && stack.func_77973_b().func_206844_a(Utils.WRENCH)) {
            return this.rotateCamo(camo, hit);
        }
        if (ServerConfig.enableIntangibleFeature && stack.func_77973_b() == ServerConfig.intangibleMarkerItem && !this.intangible && this.getBlock().getBlockType().allowMakingIntangible()) {
            if (!this.field_145850_b.func_201670_d()) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                this.setIntangible(true);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_145850_b.func_201670_d());
        }
        if (this.intangible && player.func_225608_bj_() && stack.func_77973_b().func_206844_a(Utils.WRENCH)) {
            if (!this.field_145850_b.func_201670_d()) {
                this.setIntangible(false);
                ItemStack result = new ItemStack((IItemProvider)ServerConfig.intangibleMarkerItem);
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_145850_b.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    private ActionResultType clearBlockCamo(PlayerEntity player, BlockRayTraceResult hit) {
        if (!this.field_145850_b.func_201670_d()) {
            int light = this.getLightValue();
            ItemStack camoStack = this.getCamoStack(hit);
            if (!player.field_71071_by.func_70441_a(camoStack)) {
                player.func_71019_a(camoStack, false);
            }
            this.applyCamo(ItemStack.field_190927_a, Blocks.field_150350_a.func_176223_P(), hit);
            if (!this.updateDynamicStates(true, true)) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
            boolean lightUpdate = this.getLightValue() != light;
            this.func_70296_d();
            if (lightUpdate) {
                this.doLightUpdate();
            }
        }
        return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
    }

    private ActionResultType clearFluidCamo(PlayerEntity player, BlockState camo, ItemStack stack, BlockRayTraceResult hit) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.map(handler -> {
            FluidStack fluid = new FluidStack((Fluid)((FlowingFluidBlock)camo.func_177230_c()).getFluid(), 1000);
            if (handler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == 1000) {
                if (!this.field_145850_b.func_201670_d()) {
                    if (!player.func_184812_l_()) {
                        if (stack.func_77973_b() == Items.field_151133_ar) {
                            stack.func_190918_g(1);
                            ItemStack result = new ItemStack((IItemProvider)fluid.getFluid().func_204524_b());
                            if (!player.field_71071_by.func_70441_a(result)) {
                                player.func_71019_a(result, false);
                            }
                        } else {
                            handler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                        }
                    }
                    int light = this.getLightValue();
                    this.applyCamo(ItemStack.field_190927_a, Blocks.field_150350_a.func_176223_P(), hit);
                    if (!this.updateDynamicStates(true, true)) {
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                    }
                    boolean lightUpdate = this.getLightValue() != light;
                    this.func_70296_d();
                    if (lightUpdate) {
                        this.doLightUpdate();
                    }
                }
                return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
            }
            return ActionResultType.FAIL;
        }).orElse(ActionResultType.FAIL);
    }

    private ActionResultType setBlockCamo(PlayerEntity player, ItemStack stack, BlockRayTraceResult hit) {
        BlockState state = ((BlockItem)stack.func_77973_b()).func_179223_d().func_176223_P();
        if (this.isValidBlock(state, player)) {
            if (!this.field_145850_b.func_201670_d()) {
                int light = this.getLightValue();
                this.applyCamo(stack.func_77979_a(1), state, hit);
                if (!this.updateDynamicStates(true, true)) {
                    this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                }
                if (player.func_184812_l_()) {
                    stack.func_190917_f(1);
                }
                this.func_70296_d();
                if (this.getLightValue() != light) {
                    this.doLightUpdate();
                }
            }
            return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        return ActionResultType.FAIL;
    }

    private ActionResultType setFluidCamo(PlayerEntity player, ItemStack stack, BlockRayTraceResult hit) {
        LazyOptional cap = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        return cap.map(handler -> {
            FluidStack fluid = handler.getFluidInTank(0);
            BlockState state = fluid.getFluid().func_207188_f().func_206883_i();
            if (!state.func_196958_f()) {
                ItemStack bucket = new ItemStack((IItemProvider)fluid.getFluid().func_204524_b());
                if (fluid.getAmount() >= 1000 && !bucket.func_190926_b() && handler.drain(1000, IFluidHandler.FluidAction.SIMULATE).getAmount() == 1000) {
                    if (!this.field_145850_b.func_201670_d()) {
                        if (!player.func_184812_l_()) {
                            if (stack.func_77973_b() instanceof BucketItem) {
                                stack.func_190918_g(1);
                                ItemStack emptyBucket = new ItemStack((IItemProvider)Items.field_151133_ar);
                                if (!player.field_71071_by.func_70441_a(emptyBucket)) {
                                    player.func_71019_a(emptyBucket, false);
                                }
                            } else {
                                handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            }
                        }
                        int light = this.getLightValue();
                        this.applyCamo(ItemStack.field_190927_a, state, hit);
                        if (!this.updateDynamicStates(true, true)) {
                            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
                        }
                        this.func_70296_d();
                        if (this.getLightValue() != light) {
                            this.doLightUpdate();
                        }
                    }
                    return this.field_145850_b.func_201670_d() ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
                }
            }
            return ActionResultType.FAIL;
        }).orElse(ActionResultType.FAIL);
    }

    private ActionResultType rotateCamo(BlockState camo, BlockRayTraceResult hit) {
        Property<?> prop = this.getRotatableProperty(camo);
        if (prop != null) {
            if (!this.field_145850_b.func_201670_d()) {
                this.applyCamo(this.getCamoStack(hit), (BlockState)camo.func_235896_a_(prop), hit);
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_145850_b.func_201670_d());
        }
        return ActionResultType.FAIL;
    }

    private Property<?> getRotatableProperty(BlockState state) {
        for (Property prop : state.func_235904_r_()) {
            if (prop.func_177699_b() == Direction.Axis.class) {
                return prop;
            }
            if (!(prop instanceof DirectionProperty)) continue;
            return prop;
        }
        return null;
    }

    protected boolean isValidBlock(BlockState state, PlayerEntity player) {
        Block block = state.func_177230_c();
        if (block instanceof IFramedBlock) {
            return false;
        }
        if (state.func_235714_a_(Utils.BLACKLIST)) {
            if (player != null) {
                player.func_146105_b((ITextComponent)MSG_BLACKLISTED, true);
            }
            return false;
        }
        if (block.hasTileEntity(state) && !ServerConfig.allowBlockEntities) {
            if (player != null) {
                player.func_146105_b((ITextComponent)MSG_TILE_ENTITY, true);
            }
            return false;
        }
        return state.func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c) || state.func_235714_a_(Utils.FRAMEABLE);
    }

    protected void applyCamo(ItemStack camoStack, BlockState camoState, BlockRayTraceResult hit) {
        this.camoStack = camoStack;
        this.camoState = camoState;
    }

    public void setCamo(ItemStack camoStack, BlockState camoState, boolean secondary) {
        int light = this.getLightValue();
        this.camoStack = camoStack;
        this.camoState = camoState;
        this.func_70296_d();
        if (this.getLightValue() != light) {
            this.doLightUpdate();
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public boolean isSolidSide(Direction side) {
        return this.getBlock().getCtmPredicate().test(this.func_195044_w(), side) && this.camoState.func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c);
    }

    public BlockState getCamoState(Direction side) {
        return this.camoState;
    }

    protected BlockState getCamoState(BlockRayTraceResult hit) {
        return this.camoState;
    }

    public BlockState getCamoState() {
        return this.camoState;
    }

    protected ItemStack getCamoStack(BlockRayTraceResult hit) {
        return this.camoStack;
    }

    public ItemStack getCamoStack() {
        return this.camoStack;
    }

    protected boolean isCamoSolid() {
        return !this.camoState.func_196958_f() && this.camoState.func_200015_d((IBlockReader)this.field_145850_b, this.field_174879_c);
    }

    public final void checkCamoSolid() {
        if (this.getBlock().getBlockType().canOccludeWithSolidCamo() && !this.camoState.func_196958_f()) {
            this.updateDynamicStates(true, false);
        }
    }

    protected final boolean updateDynamicStates(boolean updateSolid, boolean updateLight) {
        if (!this.getBlock().getBlockType().canOccludeWithSolidCamo()) {
            return false;
        }
        BlockState state = this.func_195044_w();
        boolean changed = false;
        if (updateSolid) {
            boolean solid;
            boolean wasSolid = (Boolean)this.func_195044_w().func_177229_b((Property)PropertyHolder.SOLID);
            boolean bl = solid = !this.intangible && this.isCamoSolid();
            if (solid != wasSolid) {
                state = (BlockState)state.func_206870_a((Property)PropertyHolder.SOLID, (Comparable)Boolean.valueOf(solid));
                changed = true;
            }
        }
        if (updateLight) {
            boolean isGlowing;
            boolean bl = isGlowing = this.getLightValue() > 0;
            if (isGlowing != (Boolean)state.func_177229_b((Property)PropertyHolder.GLOWING)) {
                state = (BlockState)state.func_206870_a((Property)PropertyHolder.GLOWING, (Comparable)Boolean.valueOf(isGlowing));
                changed = true;
            }
        }
        if (changed) {
            this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
        }
        return changed;
    }

    public float getCamoBlastResistance(Explosion explosion) {
        return this.camoState.getExplosionResistance((IBlockReader)this.field_145850_b, this.field_174879_c, explosion);
    }

    public boolean isCamoFlammable(Direction face) {
        return this.camoState.func_196958_f() || this.camoState.isFlammable((IBlockReader)this.field_145850_b, this.field_174879_c, face);
    }

    public int getCamoFlammability(Direction face) {
        return this.getCamoState().func_196958_f() ? -1 : this.getCamoState().getFlammability((IBlockReader)this.field_145850_b, this.field_174879_c, face);
    }

    public void setGlowing(boolean glowing) {
        if (this.glowing != glowing) {
            int oldLight = this.getLightValue();
            this.glowing = glowing;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.func_70296_d();
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public int getLightValue() {
        if (this.glowing) {
            return 15;
        }
        return this.camoState.func_185906_d();
    }

    public void setIntangible(boolean intangible) {
        if (this.intangible != intangible) {
            this.intangible = intangible;
            this.func_70296_d();
            if (!this.updateDynamicStates(true, false)) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
            }
        }
    }

    public boolean isIntangible(ISelectionContext ctx) {
        if (!ServerConfig.enableIntangibleFeature || !this.intangible) {
            return false;
        }
        if (ctx instanceof EntitySelectionContext && ctx.getEntity() instanceof PlayerEntity) {
            ItemStack mainItem = ((PlayerEntity)ctx.getEntity()).func_184614_ca();
            return !mainItem.func_77973_b().func_206844_a(Utils.WRENCH) && mainItem.func_77973_b() != FBContent.itemFramedHammer.get();
        }
        return true;
    }

    protected void doLightUpdate() {
        this.field_145850_b.func_72863_F().func_212863_j_().func_215568_a(this.field_174879_c);
    }

    public final IFramedBlock getBlock() {
        return (IFramedBlock)this.func_195044_w().func_177230_c();
    }

    public void addCamoDrops(List<ItemStack> drops) {
        if (!this.camoStack.func_190926_b()) {
            drops.add(this.camoStack);
        }
    }

    public MaterialColor getMapColor() {
        if (!this.camoState.func_196958_f()) {
            return this.camoState.func_185909_g((IBlockReader)this.field_145850_b, this.field_174879_c);
        }
        return null;
    }

    public void checkSolidStateOnLoad() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d() && this.recheckStates) {
            this.checkCamoSolid();
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.writeToDataPacket(nbt);
        return new SUpdateTileEntityPacket(this.field_174879_c, -1, nbt);
    }

    public final void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT nbt = pkt.func_148857_g();
        if (this.readFromDataPacket(nbt)) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    protected void writeToDataPacket(CompoundNBT nbt) {
        nbt.func_218657_a("camo_stack", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        nbt.func_74757_a("glowing", this.glowing);
        nbt.func_74757_a("intangible", this.intangible);
    }

    protected boolean readFromDataPacket(CompoundNBT nbt) {
        boolean newIntangible;
        boolean newGlow;
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack"));
        boolean needUpdate = false;
        BlockState newState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state"));
        if (newState != this.camoState) {
            int oldLight = this.getLightValue();
            this.camoState = newState;
            if (oldLight != this.getLightValue()) {
                this.doLightUpdate();
            }
            this.modelData.setWorld(this.field_145850_b);
            this.modelData.setPos(this.field_174879_c);
            this.modelData.setCamoState(this.camoState);
            needUpdate = true;
        }
        if ((newGlow = nbt.func_74767_n("glowing")) != this.glowing) {
            this.glowing = newGlow;
            needUpdate = true;
            this.doLightUpdate();
        }
        if ((newIntangible = nbt.func_74767_n("intangible")) != this.intangible) {
            this.intangible = newIntangible;
            needUpdate = true;
        }
        return needUpdate;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_218657_a("camo_stack", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        nbt.func_74757_a("glowing", this.glowing);
        nbt.func_74757_a("intangible", this.intangible);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack"));
        BlockState newState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state"));
        if (newState != this.camoState) {
            this.camoState = newState;
            this.modelData.setWorld(this.field_145850_b);
            this.modelData.setPos(this.field_174879_c);
            this.modelData.setCamoState(this.camoState);
        }
        this.glowing = nbt.func_74767_n("glowing");
        this.intangible = nbt.func_74767_n("intangible");
    }

    public IModelData getModelData() {
        return this.modelData;
    }

    public CompoundNBT writeToBlueprint() {
        return this.func_189515_b(new CompoundNBT());
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("camo_stack", (INBT)this.camoStack.func_77955_b(new CompoundNBT()));
        nbt.func_218657_a("camo_state", (INBT)NBTUtil.func_190009_a((BlockState)this.camoState));
        nbt.func_74757_a("glowing", this.glowing);
        nbt.func_74757_a("intangible", this.intangible);
        nbt.func_74774_a("updated", (byte)2);
        return super.func_189515_b(nbt);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        BlockState camoState = NBTUtil.func_190008_d((CompoundNBT)nbt.func_74775_l("camo_state"));
        if (camoState.func_196958_f() || this.isValidBlock(camoState, null)) {
            this.recheckStates = nbt.func_74771_c("updated") < 2;
            this.camoState = camoState;
            this.camoStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("camo_stack"));
        } else {
            this.recheckStates = true;
            FramedBlocks.LOGGER.warn("Framed Block of type \"{}\" at position {} contains an invalid camo of type \"{}\", removing camo! This might be caused by a config or tag change!", (Object)state.func_177230_c().getRegistryName(), (Object)this.field_174879_c, (Object)camoState.func_177230_c().getRegistryName());
        }
        this.glowing = nbt.func_74767_n("glowing");
        this.intangible = nbt.func_74767_n("intangible");
        if (EffectiveSide.get().isServer()) {
            EventHandler.addNewTileEntity(this);
        }
    }
}

