/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class PanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        switch (adjBlock) {
            case FRAMED_PANEL: {
                return this.testAgainstPanel(world, pos, dir, adjState, side);
            }
            case FRAMED_DOUBLE_PANEL: {
                return this.testAgainstDoublePanel(world, pos, dir, adjState, side);
            }
            case FRAMED_CORNER_PILLAR: {
                return this.testAgainstPillar(world, pos, dir, adjState, side);
            }
            case FRAMED_SLAB_EDGE: {
                return this.testAgainstEdge(world, pos, dir, adjState, side);
            }
            case FRAMED_STAIRS: {
                return this.testAgainstStairs(world, pos, dir, adjState, side);
            }
            case FRAMED_VERTICAL_STAIRS: {
                return this.testAgainstVerticalStairs(world, pos, dir, adjState, side);
            }
            case FRAMED_HALF_STAIRS: {
                return PanelSkipPredicate.testAgainstHalfStairs(world, pos, dir, adjState, side);
            }
            case FRAMED_SLOPE_PANEL: {
                return PanelSkipPredicate.testAgainstSlopePanel(world, pos, dir, adjState, side);
            }
            case FRAMED_EXTENDED_SLOPE_PANEL: {
                return PanelSkipPredicate.testAgainstExtendedSlopePanel(world, pos, dir, adjState, side);
            }
            case FRAMED_DOUBLE_SLOPE_PANEL: {
                return PanelSkipPredicate.testAgainstDoubleSlopePanel(world, pos, dir, adjState, side);
            }
            case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                return PanelSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, dir, adjState, side);
            }
        }
        return false;
    }

    private boolean testAgainstPanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.func_176734_d()) {
            return false;
        }
        return dir == adjState.func_177229_b((Property)PropertyHolder.FACING_HOR) && SideSkipPredicate.compareState(world, pos, side, dir);
    }

    private boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side == dir.func_176734_d()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        return (dir == adjDir || dir == adjDir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, dir);
    }

    private boolean testAgainstPillar(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (side == dir.func_176746_e() && adjDir == dir || side == dir.func_176735_f() && adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstEdge(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (adjDir != dir) {
            return false;
        }
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        if (side == Direction.UP && !adjTop || side == Direction.DOWN && adjTop) {
            return SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstStairs(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        boolean adjTop;
        if (side.func_176740_k() != Direction.Axis.Y) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        StairsShape adjShape = (StairsShape)adjState.func_177229_b((Property)BlockStateProperties.field_208146_au);
        boolean bl = adjTop = adjState.func_177229_b((Property)BlockStateProperties.field_208164_Q) == Half.TOP;
        if (dir != adjDir) {
            return false;
        }
        if (side == Direction.UP && adjTop || side == Direction.DOWN && !adjTop) {
            return adjShape == StairsShape.STRAIGHT && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.func_177229_b(PropertyHolder.STAIRS_TYPE));
        if (side == dir.func_176735_f() && adjDir == dir || side == dir.func_176746_e() && adjDir == dir.func_176746_e()) {
            return adjType == StairsType.VERTICAL && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (side.func_176740_k() == dir.func_176740_k()) {
            return false;
        }
        if (adjRight && adjDir == dir.func_176735_f() || !adjRight && adjDir == dir.func_176746_e()) {
            if (side.func_176740_k() == Direction.Axis.Y) {
                return side == Direction.DOWN == adjTop && SideSkipPredicate.compareState(world, pos, side, dir);
            }
            return side == adjDir.func_176734_d() && SideSkipPredicate.compareState(world, pos, side, dir);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION))).withFacing(adjDir);
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (side.func_176740_k() == dir.func_176740_k() || side != adjRotDir) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront) {
            return SideSkipPredicate.compareState(world, pos, side, dir, side.func_176734_d());
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        if (side.func_176740_k() == dir.func_176740_k()) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION))).withFacing(adjDir);
        return adjDir == dir && adjRotDir == side.func_176734_d() && SideSkipPredicate.compareState(world, pos, side, dir);
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION))).withFacing(adjDir);
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (side.func_176740_k() == dir.func_176740_k() || side.func_176740_k() != adjRotDir.func_176740_k()) {
            return false;
        }
        if (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront) {
            return SideSkipPredicate.compareState(world, pos, side, dir, side.func_176734_d());
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, Direction dir, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Direction adjRotDir = ((Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION))).withFacing(adjDir);
        if (side.func_176740_k() == dir.func_176740_k() || side.func_176740_k() != adjRotDir.func_176740_k()) {
            return false;
        }
        if (adjDir == dir && side == adjRotDir.func_176734_d() || adjDir == dir.func_176734_d() && side == adjRotDir) {
            return SideSkipPredicate.compareState(world, pos, side, dir, side.func_176734_d());
        }
        return false;
    }
}

