/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds;

import net.minecraft.block.BlockState;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.data.StairsType;
import xfacthd.framedblocks.common.util.SideSkipPredicate;

public class ExtendedSlopePanelSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(IBlockReader world, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation rot = (Rotation)((Object)state.func_177229_b(PropertyHolder.ROTATION));
        Direction rotDir = rot.withFacing(dir);
        if (side == dir || side == rotDir.func_176734_d()) {
            return SideSkipPredicate.CTM.test(world, pos, state, adjState, side);
        }
        if (!(adjState.func_177230_c() instanceof IFramedBlock)) {
            return false;
        }
        BlockType adjBlock = ((IFramedBlock)adjState.func_177230_c()).getBlockType();
        switch (adjBlock) {
            case FRAMED_EXTENDED_SLOPE_PANEL: {
                return ExtendedSlopePanelSkipPredicate.testAgainstExtendedSlopePanel(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_SLOPE_PANEL: {
                return ExtendedSlopePanelSkipPredicate.testAgainstSlopePanel(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_DOUBLE_SLOPE_PANEL: {
                return ExtendedSlopePanelSkipPredicate.testAgainstDoubleSlopePanel(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_INV_DOUBLE_SLOPE_PANEL: {
                return ExtendedSlopePanelSkipPredicate.testAgainstInverseDoubleSlopePanel(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_SLAB_EDGE: {
                return ExtendedSlopePanelSkipPredicate.testAgainstSlabEdge(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_PANEL: {
                return ExtendedSlopePanelSkipPredicate.testAgainstPanel(world, pos, adjState, side, dir, rotDir);
            }
            case FRAMED_DOUBLE_PANEL: {
                return ExtendedSlopePanelSkipPredicate.testAgainstDoublePanel(world, pos, adjState, side, dir, rotDir);
            }
            case FRAMED_CORNER_PILLAR: {
                return ExtendedSlopePanelSkipPredicate.testAgainstCornerPillar(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_STAIRS: {
                return ExtendedSlopePanelSkipPredicate.testAgainstStairs(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_VERTICAL_STAIRS: {
                return ExtendedSlopePanelSkipPredicate.testAgainstVerticalStairs(world, pos, adjState, side, dir, rot, rotDir);
            }
            case FRAMED_HALF_STAIRS: {
                return ExtendedSlopePanelSkipPredicate.testAgainstHalfStairs(world, pos, adjState, side, dir, rot, rotDir);
            }
        }
        return false;
    }

    private static boolean testAgainstExtendedSlopePanel(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (side == rotDir && adjDir == dir && adjRot == rot.getOpposite()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (side != dir.func_176734_d() && adjDir == dir && adjRot == rot) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlopePanel(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if (adjRot == rot && (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstDoubleSlopePanel(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        boolean adjFront = (Boolean)adjState.func_177229_b((Property)PropertyHolder.FRONT);
        if ((adjRot == rot || adjRot == rot.getOpposite()) && (adjDir == dir && !adjFront || adjDir == dir.func_176734_d() && adjFront)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstInverseDoubleSlopePanel(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Rotation adjRot = (Rotation)((Object)adjState.func_177229_b(PropertyHolder.ROTATION));
        if (adjRot == rot && adjDir == dir.func_176734_d() || adjRot == rot.getOpposite() && adjDir == dir) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstSlabEdge(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        if (!rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        return adjDir == dir && adjTop == (rot == Rotation.DOWN) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstPanel(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        return adjDir == dir && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstDoublePanel(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_NE);
        return (adjDir == dir || adjDir == dir.func_176734_d()) && SideSkipPredicate.compareState(world, pos, side, dir, dir);
    }

    private static boolean testAgainstCornerPillar(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        if (rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        if (rot == Rotation.RIGHT && adjDir == dir || rot == Rotation.LEFT && adjDir == dir.func_176746_e()) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstStairs(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        boolean straight;
        if (!rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)StairsBlock.field_176309_a);
        boolean adjTop = adjState.func_177229_b((Property)StairsBlock.field_176308_b) == Half.TOP;
        boolean bl = straight = adjState.func_177229_b((Property)StairsBlock.field_176310_M) == StairsShape.STRAIGHT;
        return straight && adjDir == dir && adjTop == (rot == Rotation.UP) && SideSkipPredicate.compareState(world, pos, side);
    }

    private static boolean testAgainstVerticalStairs(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        boolean adjVert;
        if (rot.isVertical() || side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean bl = adjVert = adjState.func_177229_b(PropertyHolder.STAIRS_TYPE) == StairsType.VERTICAL;
        if (adjVert && (rot == Rotation.RIGHT && adjDir == dir.func_176746_e() || rot == Rotation.LEFT && adjDir == dir)) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }

    private static boolean testAgainstHalfStairs(IBlockReader world, BlockPos pos, BlockState adjState, Direction side, Direction dir, Rotation rot, Direction rotDir) {
        if (side != rotDir) {
            return false;
        }
        Direction adjDir = (Direction)adjState.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean adjTop = (Boolean)adjState.func_177229_b((Property)PropertyHolder.TOP);
        boolean adjRight = (Boolean)adjState.func_177229_b((Property)PropertyHolder.RIGHT);
        if (rot.isVertical() && adjTop == (rot == Rotation.DOWN) && (!adjRight && adjDir == dir.func_176746_e() || adjRight && adjDir == dir.func_176735_f())) {
            return SideSkipPredicate.compareState(world, pos, side);
        }
        if (!rot.isVertical() && (adjDir == dir.func_176735_f() && adjRight || adjDir == dir.func_176746_e() && !adjRight)) {
            return adjRight == (rot == Rotation.RIGHT) && SideSkipPredicate.compareState(world, pos, side);
        }
        return false;
    }
}

