/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopePanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        if (((Boolean)state.func_177229_b((Property)PropertyHolder.FRONT)).booleanValue()) {
            return false;
        }
        return side == state.func_177229_b((Property)PropertyHolder.FACING_HOR);
    };
    public static final Map<Rotation, VoxelShape> SHAPES = (Map)Util.func_200696_a(new EnumMap(Rotation.class), map -> {
        map.put(Rotation.UP, VoxelShapes.func_216384_a((VoxelShape)FramedSlopePanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.func_208617_a((double)0.0, (double)0.5, (double)0.0, (double)16.0, (double)4.0, (double)7.75), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)6.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).func_197753_c());
        map.put(Rotation.RIGHT, VoxelShapes.func_216384_a((VoxelShape)FramedSlopePanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.func_208617_a((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)7.75), FramedSlopePanelBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)0.5)}).func_197753_c());
        map.put(Rotation.DOWN, VoxelShapes.func_216384_a((VoxelShape)FramedSlopePanelBlock.func_208617_a((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.5, (double)7.75), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)12.0, (double)6.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)4.0, (double)2.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)0.5)}).func_197753_c());
        map.put(Rotation.LEFT, VoxelShapes.func_216384_a((VoxelShape)FramedSlopePanelBlock.func_208617_a((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape[])new VoxelShape[]{FramedSlopePanelBlock.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)7.75), FramedSlopePanelBlock.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)6.0), FramedSlopePanelBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)4.0), FramedSlopePanelBlock.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)2.0), FramedSlopePanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)0.5)}).func_197753_c());
    });

    public FramedSlopePanelBlock() {
        super(BlockType.FRAMED_SLOPE_PANEL);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, PropertyHolder.SOLID, PropertyHolder.GLOWING, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    public static BlockState getStateForPlacement(Block block, BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        Direction side = context.func_196000_l();
        Rotation rotation = side == facing.func_176734_d() ? Rotation.fromWallCross(context.func_221532_j(), side) : Rotation.fromDirection(facing, side);
        boolean front = false;
        if (side.func_176740_k() != facing.func_176740_k()) {
            Vector3d subHit = Utils.fraction(context.func_221532_j());
            double xz = Utils.isX(facing) ? subHit.field_72450_a : subHit.field_72449_c;
            front = xz < 0.5 == Utils.isPositive(facing);
        }
        BlockState state = (BlockState)((BlockState)((BlockState)block.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing)).func_206870_a(PropertyHolder.ROTATION, (Comparable)((Object)rotation))).func_206870_a((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(front));
        return FramedSlopePanelBlock.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = SHAPES.get(state.func_177229_b(PropertyHolder.ROTATION));
            if (((Boolean)state.func_177229_b((Property)PropertyHolder.FRONT)).booleanValue()) {
                shape = shape.func_197751_a(0.0, 0.0, 0.5);
            }
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

