/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.tileentity.FramedFlowerPotTileEntity;

public class FramedFlowerPotBlock
extends FramedBlock {
    public FramedFlowerPotBlock() {
        super(BlockType.FRAMED_FLOWER_POT);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ActionResultType result = super.func_225533_a_(state, world, pos, player, hand, hit);
        if (result != ActionResultType.PASS) {
            return result;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedFlowerPotTileEntity) {
            boolean isFlower;
            FramedFlowerPotTileEntity pot = (FramedFlowerPotTileEntity)te;
            ItemStack stack = player.func_184586_b(hand);
            Item item = stack.func_77973_b();
            boolean bl = isFlower = item instanceof BlockItem && !FramedFlowerPotBlock.getFlowerPotState(((BlockItem)item).func_179223_d()).func_196958_f();
            if (isFlower != pot.hasFlowerBlock()) {
                if (!world.func_201670_d()) {
                    if (isFlower && !pot.hasFlowerBlock()) {
                        pot.setFlowerBlock(((BlockItem)stack.func_77973_b()).func_179223_d());
                        player.func_195066_a(Stats.field_188088_V);
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                    } else {
                        ItemStack flowerStack = new ItemStack((IItemProvider)pot.getFlowerBlock());
                        if (stack.func_190926_b()) {
                            player.func_184611_a(hand, flowerStack);
                        } else if (!player.func_191521_c(flowerStack)) {
                            player.func_71019_a(flowerStack, false);
                        }
                        pot.setFlowerBlock(Blocks.field_150350_a);
                    }
                }
                return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
            }
            return ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedFlowerPotTileEntity();
    }

    public static BlockState getFlowerPotState(Block flower) {
        Map fullPots = ((FlowerPotBlock)Blocks.field_150457_bL).getFullPotsView();
        return ((Block)((Supplier)fullPots.getOrDefault(flower.getRegistryName(), Blocks.field_150350_a.delegate)).get()).func_176223_P();
    }
}

