/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedExtendedSlopePanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        Direction orientation = ((Rotation)((Object)((Object)state.func_177229_b(PropertyHolder.ROTATION)))).withFacing(facing);
        return side == facing || side == orientation.func_176734_d();
    };
    private static final Map<Rotation, VoxelShape> SHAPES = (Map)Util.func_200696_a(new EnumMap(Rotation.class), map -> {
        for (Rotation rot : Rotation.values()) {
            VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)FramedExtendedSlopePanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot).func_197751_a(0.0, 0.0, 0.5));
            map.put(rot, shape);
        }
    });

    public FramedExtendedSlopePanelBlock() {
        super(BlockType.FRAMED_EXTENDED_SLOPE_PANEL);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.SOLID, PropertyHolder.GLOWING, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction facing = context.func_195992_f();
        Direction side = context.func_196000_l();
        Rotation rotation = side == facing.func_176734_d() ? Rotation.fromWallCross(context.func_221532_j(), side) : Rotation.fromDirection(facing, side);
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing)).func_206870_a(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return FramedExtendedSlopePanelBlock.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = SHAPES.get(state.func_177229_b(PropertyHolder.ROTATION));
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

