/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedDoubleSlopePanelTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedDoubleSlopePanelBlock
extends AbstractFramedDoubleBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        boolean front = (Boolean)state.func_177229_b((Property)PropertyHolder.FRONT);
        return !front && side == facing || front && side == facing.func_176734_d();
    };

    public FramedDoubleSlopePanelBlock() {
        super(BlockType.FRAMED_DOUBLE_SLOPE_PANEL);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FRONT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.ROTATION, PropertyHolder.FRONT, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return FramedSlopePanelBlock.getStateForPlacement(this, context);
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedDoubleSlopePanelTileEntity();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedDoubleSlopePanelBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            if (((Boolean)state.func_177229_b((Property)PropertyHolder.FRONT)).booleanValue()) {
                dir = dir.func_176734_d();
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return builder.build();
    }
}

