/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.Utils;

public class FramedCornerPillarBlock
extends FramedBlock {
    public FramedCornerPillarBlock() {
        super(BlockType.FRAMED_CORNER_PILLAR);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        Direction face = context.func_196000_l();
        Vector3d hitPoint = Utils.fraction(context.func_221532_j());
        if (face.func_176740_k().func_176722_c()) {
            boolean xAxis = face.func_176740_k() == Direction.Axis.X;
            boolean positive = face.func_176735_f().func_176743_c() == Direction.AxisDirection.POSITIVE;
            double xz = xAxis ? hitPoint.func_82616_c() : hitPoint.func_82615_a();
            Direction dir = face.func_176734_d();
            if (xz > 0.5 == positive) {
                dir = dir.func_176746_e();
            }
            state = (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
        } else {
            double z;
            Direction dir;
            double x = hitPoint.func_82615_a();
            if (x > 0.5 == ((dir = (z = hitPoint.func_82616_c()) > 0.5 ? Direction.SOUTH : Direction.NORTH).func_176743_c() == Direction.AxisDirection.NEGATIVE)) {
                dir = dir.func_176746_e();
            }
            state = (BlockState)state.func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)dir);
        }
        return FramedCornerPillarBlock.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedCornerPillarBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return builder.build();
    }
}

