/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedCollapsibleTileEntity;
import xfacthd.framedblocks.common.util.CtmPredicate;

public class FramedCollapsibleBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> {
        CollapseFace face = (CollapseFace)((Object)((Object)state.func_177229_b(PropertyHolder.COLLAPSED_FACE)));
        if (face == CollapseFace.NONE) {
            return true;
        }
        return dir == face.toDirection().func_176734_d();
    };
    private static final LoadingCache<Integer, VoxelShape> SHAPE_CACHE = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new ShapeLoader());

    public FramedCollapsibleBlock(BlockType blockType) {
        super(blockType, IFramedBlock.createProperties(BlockType.FRAMED_COLLAPSIBLE_BLOCK).func_208770_d());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.COLLAPSED_FACE, BlockStateProperties.field_208198_y});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return FramedCollapsibleBlock.withWater(this.func_176223_P(), (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static boolean onLeftClick(World world, BlockPos pos, PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() != FBContent.itemFramedHammer.get()) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedCollapsibleTileEntity) {
            if (!world.func_201670_d()) {
                ((FramedCollapsibleTileEntity)te).handleDeform(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        TileEntity te;
        if (this.isIntangible(state, world, pos, ctx)) {
            return VoxelShapes.func_197880_a();
        }
        CollapseFace face = (CollapseFace)((Object)state.func_177229_b(PropertyHolder.COLLAPSED_FACE));
        if (face != CollapseFace.NONE && (te = world.func_175625_s(pos)) instanceof FramedCollapsibleTileEntity) {
            int offsets = ((FramedCollapsibleTileEntity)te).getPackedOffsets();
            return (VoxelShape)SHAPE_CACHE.getUnchecked((Object)(offsets |= face.toDirection().func_176745_a() << 20));
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader level) {
        return new FramedCollapsibleTileEntity();
    }

    private static class ShapeLoader
    extends CacheLoader<Integer, VoxelShape> {
        private ShapeLoader() {
        }

        public VoxelShape load(Integer packedData) {
            Direction face = Direction.func_82600_a((int)(packedData >> 20));
            byte[] offsets = FramedCollapsibleTileEntity.unpackOffsets(packedData & 0xFFFFF);
            boolean positive = face.func_176743_c() == Direction.AxisDirection.POSITIVE;
            boolean flipX = face == Direction.NORTH || face == Direction.EAST;
            boolean flipZ = face != Direction.UP;
            VoxelShape result = VoxelShapes.func_197880_a();
            for (int x = 0; x < 4; ++x) {
                for (int z = 0; z < 4; ++z) {
                    VoxelShape shape;
                    double x0 = flipX ? 1.0 - (double)x / 4.0 : (double)x / 4.0;
                    double x1 = flipX ? 1.0 - (double)(x + 1) / 4.0 : (double)(x + 1) / 4.0;
                    double z0 = flipZ ? 1.0 - (double)z / 4.0 : (double)z / 4.0;
                    double z1 = flipZ ? 1.0 - (double)(z + 1) / 4.0 : (double)(z + 1) / 4.0;
                    double y0 = MathHelper.func_219804_a((double)x0, (double)z0, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                    double y1 = MathHelper.func_219804_a((double)x1, (double)z1, (double)offsets[0], (double)offsets[3], (double)offsets[1], (double)offsets[2]);
                    double y = positive ? Math.max(16.0 - Math.min(y0, y1), (double)2.0E-5f) : Math.min(Math.min(y0, y1), 15.999980000000505);
                    switch (face) {
                        case NORTH: {
                            shape = Block.func_208617_a((double)(x * 4), (double)(z * 4), (double)y, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)16.0);
                            break;
                        }
                        case EAST: {
                            shape = Block.func_208617_a((double)0.0, (double)(z * 4), (double)(x * 4), (double)y, (double)((z + 1) * 4), (double)((x + 1) * 4));
                            break;
                        }
                        case SOUTH: {
                            shape = Block.func_208617_a((double)(x * 4), (double)(z * 4), (double)0.0, (double)((x + 1) * 4), (double)((z + 1) * 4), (double)y);
                            break;
                        }
                        case WEST: {
                            shape = Block.func_208617_a((double)y, (double)(z * 4), (double)(x * 4), (double)16.0, (double)((z + 1) * 4), (double)((x + 1) * 4));
                            break;
                        }
                        case UP: {
                            shape = Block.func_208617_a((double)(x * 4), (double)0.0, (double)(z * 4), (double)((x + 1) * 4), (double)y, (double)((z + 1) * 4));
                            break;
                        }
                        case DOWN: {
                            shape = Block.func_208617_a((double)(x * 4), (double)y, (double)(z * 4), (double)((x + 1) * 4), (double)16.0, (double)((z + 1) * 4));
                            break;
                        }
                        default: {
                            throw new IncompatibleClassChangeError("Direction enum was tampered with!");
                        }
                    }
                    result = VoxelShapes.func_197882_b((VoxelShape)result, (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                }
            }
            result = result.func_197753_c();
            return result;
        }
    }
}

