/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ClientConfig INSTANCE;
    public static boolean showGhostBlocks;
    public static boolean fancyHitboxes;
    public static boolean detailedCulling;
    private final ForgeConfigSpec.BooleanValue showGhostBlocksValue;
    private final ForgeConfigSpec.BooleanValue fancyHitboxesValue;
    private final ForgeConfigSpec.BooleanValue detailedCullingValue;

    public ClientConfig(ForgeConfigSpec.Builder builder) {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        builder.push("general");
        this.showGhostBlocksValue = builder.comment("Wether ghost blocks are shown when you are holding a framed block").translation("config.framedblocks.showGhostBlocks").define("showGhostBlocks", true);
        this.fancyHitboxesValue = builder.comment("Wether certain framed blocks should show fancy hitboxes").translation("config.framedblocks.fancyHitboxes").define("fancyHitboxes", true);
        this.detailedCullingValue = builder.comment("If false only full block faces of framed blocks will be culled, if true all outer faces of famed blocks can be culled").translation("config.framedblocks.detailedCulling").define("detailedCulling", true);
        builder.pop();
    }

    @SubscribeEvent
    public void onConfigReloaded(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT && event.getConfig().getModId().equals("framedblocks")) {
            showGhostBlocks = (Boolean)this.showGhostBlocksValue.get();
            fancyHitboxes = (Boolean)this.fancyHitboxesValue.get();
            detailedCulling = (Boolean)this.detailedCullingValue.get();
        }
    }

    static {
        showGhostBlocks = false;
        fancyHitboxes = false;
        detailedCulling = false;
        Pair configSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        SPEC = (ForgeConfigSpec)configSpecPair.getRight();
        INSTANCE = (ClientConfig)configSpecPair.getLeft();
    }
}

