/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;

public class FramedPaneModel
extends FramedBlockModel {
    protected final boolean north;
    protected final boolean east;
    protected final boolean south;
    protected final boolean west;

    public FramedPaneModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.north = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208151_D);
        this.east = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208152_E);
        this.south = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208153_F);
        this.west = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208154_G);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.func_178210_d();
        if (face.func_176740_k() == Direction.Axis.Y) {
            this.createTopBottomCenterQuad(quadMap, quad, false);
            if (this.north) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, false);
            }
            if (this.east) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, false);
            }
            if (this.south) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, false);
            }
            if (this.west) {
                this.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, false);
            }
        } else {
            this.createSideEdgeQuad(quadMap, quad, this.isSideInset(face), false);
            if (face.func_176740_k() == Direction.Axis.X) {
                if (this.north) {
                    this.createSideQuad(quadMap.get(null), quad, false);
                }
                if (this.south) {
                    this.createSideQuad(quadMap.get(null), quad, true);
                }
            }
            if (face.func_176740_k() == Direction.Axis.Z) {
                if (this.east) {
                    this.createSideQuad(quadMap.get(null), quad, true);
                }
                if (this.west) {
                    this.createSideQuad(quadMap.get(null), quad, false);
                }
            }
        }
    }

    protected void createTopBottomCenterQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean mirrored) {
        BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.4375f, 0.4375f, 0.5625f, 0.5625f)) {
            if (mirrored) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.001f);
                quadMap.get(null).add(topBotQuad);
            } else {
                quadMap.get(quad.func_178210_d()).add(topBotQuad);
            }
        }
    }

    protected void createTopBottomEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean mirrored) {
        float maxZ;
        float minZ;
        float maxX;
        float minX;
        boolean positive;
        if (dir.func_176740_k() == Direction.Axis.Y) {
            throw new IllegalArgumentException(String.format("Invalid direction: %s!", dir));
        }
        boolean bl = positive = dir.func_176743_c() == Direction.AxisDirection.POSITIVE;
        if (dir.func_176740_k() == Direction.Axis.X) {
            minX = positive ? 0.5625f : 0.0f;
            maxX = positive ? 1.0f : 0.4375f;
            minZ = 0.4375f;
            maxZ = 0.5625f;
        } else {
            minX = 0.4375f;
            maxX = 0.5625f;
            minZ = positive ? 0.5625f : 0.0f;
            maxZ = positive ? 1.0f : 0.4375f;
        }
        BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
            if (mirrored) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.001f);
                quadMap.get(null).add(topBotQuad);
            } else {
                quadMap.get(quad.func_178210_d()).add(topBotQuad);
            }
        }
    }

    protected void createSideEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean inset, boolean mirrored) {
        if (inset && mirrored) {
            throw new IllegalArgumentException("Quad can't be mirrored and inset!");
        }
        BakedQuad edgeQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(edgeQuad, 0.4375f, 0.0f, 0.5625f, 1.0f)) {
            if (inset) {
                BakedQuadTransformer.setQuadPosInFacingDir(edgeQuad, 0.5625f);
                quadMap.get(null).add(edgeQuad);
            } else if (mirrored) {
                BakedQuadTransformer.setQuadPosInFacingDir(edgeQuad, 0.001f);
                quadMap.get(quad.func_178210_d().func_176734_d()).add(edgeQuad);
            } else {
                quadMap.get(quad.func_178210_d()).add(edgeQuad);
            }
        }
    }

    private void createSideQuad(List<BakedQuad> quadList, BakedQuad quad, boolean positive) {
        float minXZ = positive ? 0.5625f : 0.0f;
        float maxXZ = positive ? 1.0f : 0.4375f;
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.0f, maxXZ, 1.0f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
            quadList.add(sideQuad);
        }
    }

    protected boolean isSideInset(Direction face) {
        if (face == Direction.NORTH) {
            return !this.north;
        }
        if (face == Direction.EAST) {
            return !this.east;
        }
        if (face == Direction.SOUTH) {
            return !this.south;
        }
        if (face == Direction.WEST) {
            return !this.west;
        }
        throw new IllegalArgumentException(String.format("Invalid face: %s!", face));
    }
}

