/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedLatticeModel
extends FramedBlockModel {
    private final boolean xAxis;
    private final boolean yAxis;
    private final boolean zAxis;

    public FramedLatticeModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.xAxis = (Boolean)state.func_177229_b((Property)PropertyHolder.X_AXIS);
        this.yAxis = (Boolean)state.func_177229_b((Property)PropertyHolder.Y_AXIS);
        this.zAxis = (Boolean)state.func_177229_b((Property)PropertyHolder.Z_AXIS);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.func_178210_d() == Direction.UP || quad.func_178210_d() == Direction.DOWN) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
                if (this.yAxis) {
                    quadMap.get(quad.func_178210_d()).add(topBotQuad);
                } else {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            }
            if (this.xAxis) {
                topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0f, 0.375f, 0.375f, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), 0.625f, 0.375f, 1.0f, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            }
            if (this.zAxis) {
                topBotQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.375f, 0.0f, 0.625f, 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topBotQuad = ModelUtils.duplicateQuad(quad), 0.375f, 0.625f, 0.625f, 1.0f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.625f);
                    quadMap.get(null).add(topBotQuad);
                }
            }
        } else if (quad.func_178210_d().func_176740_k() == Direction.Axis.X) {
            this.createHorizontalStrutSideQuads(quadMap, quad, this.xAxis, this.zAxis);
        } else if (quad.func_178210_d().func_176740_k() == Direction.Axis.Z) {
            this.createHorizontalStrutSideQuads(quadMap, quad, this.zAxis, this.xAxis);
        }
        if (quad.func_178210_d().func_176740_k() != Direction.Axis.Y && this.yAxis) {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.375f, 0.0f, 0.625f, 0.375f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
            if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.375f, 0.625f, 0.625f, 1.0f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }

    private void createHorizontalStrutSideQuads(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean frontAxis, boolean sideAxis) {
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
            if (frontAxis) {
                quadMap.get(quad.func_178210_d()).add(sideQuad);
            } else {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (sideAxis) {
            sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0f, 0.375f, 0.375f, 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
            if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.625f, 0.375f, 1.0f, 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                quadMap.get(null).add(sideQuad);
            }
        }
    }
}

