/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.FramedBlockData;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedFlowerPotBlock;
import xfacthd.framedblocks.common.tileentity.FramedFlowerPotTileEntity;

public class FramedFlowerPotModel
extends BakedModelProxy {
    private final Map<Block, PotModel> CACHE_BY_PLANT = new HashMap<Block, PotModel>();

    public FramedFlowerPotModel(BlockState state, IBakedModel baseModel) {
        super(baseModel);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getOrCreatePotModel(state, extraData).getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.getOrCreatePotModel(((Block)FBContent.blockFramedFlowerPot.get()).func_176223_P(), data).getParticleTexture(data);
    }

    private PotModel getOrCreatePotModel(BlockState state, IModelData extraData) {
        Block flower = (Block)Optional.ofNullable(extraData.getData(FramedFlowerPotTileEntity.FLOWER_BLOCK)).orElse(Blocks.field_150350_a);
        return this.CACHE_BY_PLANT.computeIfAbsent(flower, block -> new PotModel(state, this.baseModel, flower));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedFlowerPotTileEntity) {
            return te.getModelData();
        }
        return tileData;
    }

    private static class PotModel
    extends FramedBlockModel {
        private final Block flower;

        public PotModel(BlockState state, IBakedModel baseModel, Block flower) {
            super(state, baseModel);
            this.flower = flower;
        }

        @Override
        protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
            if (quad.func_178210_d() == Direction.DOWN) {
                BakedQuad botQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(botQuad, 0.3125f, 0.3125f, 0.6875f, 0.6875f)) {
                    quadMap.get(Direction.DOWN).add(botQuad);
                }
            } else if (quad.func_178210_d() == Direction.UP) {
                BakedQuad topQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createTopBottomQuad(topQuad, 0.3125f, 0.3125f, 0.6875f, 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topQuad, 0.375f);
                    quadMap.get(null).add(topQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topQuad = ModelUtils.duplicateQuad(quad), 0.3125f, 0.625f, 0.6875f, 0.6875f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topQuad, 0.375f);
                    quadMap.get(null).add(topQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topQuad = ModelUtils.duplicateQuad(quad), 0.3125f, 0.375f, 0.375f, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topQuad, 0.375f);
                    quadMap.get(null).add(topQuad);
                }
                if (BakedQuadTransformer.createTopBottomQuad(topQuad = ModelUtils.duplicateQuad(quad), 0.625f, 0.375f, 0.6875f, 0.625f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topQuad, 0.375f);
                    quadMap.get(null).add(topQuad);
                }
            } else if (quad.func_178210_d().func_176740_k() != Direction.Axis.Y) {
                BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
                if (BakedQuadTransformer.createSideQuad(sideQuad, 0.3125f, 0.0f, 0.6875f, 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.6875f);
                    quadMap.get(null).add(sideQuad);
                }
                if (BakedQuadTransformer.createSideQuad(sideQuad = ModelUtils.duplicateQuad(quad), 0.375f, 0.0625f, 0.625f, 0.375f)) {
                    BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.375f);
                    quadMap.get(null).add(sideQuad);
                }
            }
        }

        @Override
        protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
            return RenderTypeLookup.canRenderInLayer((BlockState)Blocks.field_150346_d.func_176223_P(), (RenderType)layer) || RenderTypeLookup.canRenderInLayer((BlockState)this.flower.func_176223_P(), (RenderType)layer);
        }

        @Override
        protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
            BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
            BlockState potState = FramedFlowerPotBlock.getFlowerPotState(this.flower);
            if (!potState.func_196958_f() && RenderTypeLookup.canRenderInLayer((BlockState)this.flower.func_176223_P(), (RenderType)layer)) {
                IBakedModel potModel = dispatcher.func_184389_a(potState);
                Arrays.stream(Direction.values()).map(dir -> Pair.of((Object)dir, this.getFilteredPlantQuads(potState, potModel, (Direction)dir, rand))).forEach(pair -> ((List)quadMap.get(pair.getFirst())).addAll((Collection)pair.getSecond()));
                quadMap.get(null).addAll(this.getFilteredPlantQuads(potState, potModel, null, rand));
            }
            if (RenderTypeLookup.canRenderInLayer((BlockState)Blocks.field_150346_d.func_176223_P(), (RenderType)layer)) {
                BlockState camoState;
                IBakedModel dirtModel = dispatcher.func_184389_a(Blocks.field_150346_d.func_176223_P());
                dirtModel.getQuads(Blocks.field_150346_d.func_176223_P(), Direction.UP, rand, (IModelData)EmptyModelData.INSTANCE).forEach(q -> {
                    BakedQuad topQuad = ModelUtils.duplicateQuad(q);
                    if (BakedQuadTransformer.createTopBottomQuad(topQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
                        BakedQuadTransformer.setQuadPosInFacingDir(topQuad, 0.25f);
                        ((List)quadMap.get(null)).add(topQuad);
                    }
                });
                BlockState blockState = camoState = data instanceof FramedBlockData ? ((FramedBlockData)data).getCamoState() : Blocks.field_150350_a.func_176223_P();
                if (!camoState.func_200132_m()) {
                    dirtModel.getQuads(Blocks.field_150346_d.func_176223_P(), Direction.DOWN, rand, (IModelData)EmptyModelData.INSTANCE).forEach(q -> {
                        BakedQuad botQuad = ModelUtils.duplicateQuad(q);
                        if (BakedQuadTransformer.createTopBottomQuad(botQuad, 0.375f, 0.375f, 0.625f, 0.625f)) {
                            BakedQuadTransformer.setQuadPosInFacingDir(botQuad, 0.9375f);
                            ((List)quadMap.get(null)).add(botQuad);
                        }
                    });
                    Direction.Plane.HORIZONTAL.func_239636_a_().flatMap(face -> dirtModel.getQuads(Blocks.field_150350_a.func_176223_P(), face, rand, (IModelData)EmptyModelData.INSTANCE).stream()).forEach(q -> {
                        BakedQuad sideQuad = ModelUtils.duplicateQuad(q);
                        if (BakedQuadTransformer.createSideQuad(sideQuad, 0.375f, 0.0625f, 0.625f, 0.25f)) {
                            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.625f);
                            ((List)quadMap.get(null)).add(sideQuad);
                        }
                    });
                }
            }
        }

        private List<BakedQuad> getFilteredPlantQuads(BlockState potState, IBakedModel potModel, Direction face, Random rand) {
            return potModel.getQuads(potState, face, rand, (IModelData)EmptyModelData.INSTANCE).stream().filter(q -> !q.func_187508_a().func_195668_m().func_110623_a().equals("block/flower_pot")).filter(q -> !q.func_187508_a().func_195668_m().func_110623_a().equals("block/dirt")).map(ModelUtils::invertTintIndex).collect(Collectors.toList());
        }
    }
}

