/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.model.FramedSlopePanelModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.Rotation;
import xfacthd.framedblocks.common.util.Utils;

public class FramedExtendedSlopePanelModel
extends FramedBlockModel {
    private final Direction facing;
    private final Rotation rotation;
    private final Direction orientation;

    public FramedExtendedSlopePanelModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.rotation = (Rotation)((Object)state.func_177229_b(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.func_178210_d();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation) {
            Direction cutDir = this.facing.func_176734_d();
            BakedQuad slabQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis && BakedQuadTransformer.createTopBottomQuad(slabQuad, cutDir, 0.5f) || !yAxis && BakedQuadTransformer.createVerticalSideQuad(slabQuad, cutDir, 0.5f)) {
                quadMap.get(face).add(slabQuad);
            }
        } else if (face == this.facing.func_176734_d()) {
            BakedQuad slopeQuad = FramedSlopePanelModel.createSlope(quad, this.facing, this.orientation);
            quadMap.get(null).add(slopeQuad);
        } else if (face.func_176740_k() != this.facing.func_176740_k() && face.func_176740_k() != this.orientation.func_176740_k()) {
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (yAxis) {
                if (BakedQuadTransformer.createVerticalSideTriangleQuad(triQuad, face == this.facing.func_176746_e(), this.rotation == Rotation.DOWN, 1.0f, 0.5f)) {
                    quadMap.get(face).add(triQuad);
                }
            } else if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.facing.func_176734_d(), this.rotation == Rotation.RIGHT, 1.0f, 0.5f)) {
                quadMap.get(face).add(triQuad);
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedExtendedSlopePanel.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

