/*
 * Decompiled with CFR 0.152.
 */
package cofh.nonvflash;

import cofh.nonvflash.NoNVFlash;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class Config {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec clientSpec;
    public static ForgeConfigSpec.BooleanValue clientFadeOut;
    public static ForgeConfigSpec.IntValue clientFadeOutTicks;
    public static ForgeConfigSpec.DoubleValue clientMaxBrightness;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
        registered = true;
        Config.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private Config() {
    }

    private static void genClientConfig() {
        clientFadeOut = CLIENT_CONFIG.comment("If TRUE, Night Vision brightness will gradually fade over a number of ticks instead of abruptly stopping.").define("Fade Out", true);
        clientFadeOutTicks = CLIENT_CONFIG.comment("If the fade out option is enabled (TRUE), adjust this value to change the duration of the fade.").defineInRange("Fade Out Ticks", 20, 10, 200);
        clientMaxBrightness = CLIENT_CONFIG.comment("Adjust this value to change the default brightness of the Night Vision effect. Setting this to 0 will effectively disable it.").defineInRange("Max Brightness", 1.0, 0.0, 1.0);
        clientSpec = CLIENT_CONFIG.build();
        Config.refreshClientConfig();
    }

    private static void refreshClientConfig() {
        NoNVFlash.fadeOut = (Boolean)clientFadeOut.get();
        NoNVFlash.fadeTicks = (Integer)clientFadeOutTicks.get();
        NoNVFlash.maxBrightness = ((Double)clientMaxBrightness.get()).floatValue();
        NoNVFlash.fadeRate = NoNVFlash.maxBrightness / (float)NoNVFlash.fadeTicks;
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.refreshClientConfig();
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.refreshClientConfig();
        }
    }
}

