/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world.gen.feature;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.init.ModBlock;

public class FeatureUnderwaterAlgae
extends Feature<NoFeatureConfig> {
    public FeatureUnderwaterAlgae(Codec<NoFeatureConfig> p_i231988_1_) {
        super(p_i231988_1_);
    }

    public boolean generate(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        BlockState blockstate;
        boolean flag = false;
        int i = rand.nextInt(8) - rand.nextInt(8);
        int j = rand.nextInt(8) - rand.nextInt(8);
        int k = reader.func_201676_a(Heightmap.Type.OCEAN_FLOOR, pos.func_177958_n() + i, pos.func_177952_p() + j);
        BlockPos blockpos = new BlockPos(pos.func_177958_n() + i, k, pos.func_177952_p() + j);
        Pair<Block, Integer> algae = AlgaeTypes.getAlgaeForPos((IWorld)reader, blockpos);
        if (reader.func_180495_p(blockpos).func_203425_a(Blocks.field_150355_j) && algae != null && (blockstate = ((Block)algae.getFirst()).func_176223_P()).func_196955_c((IWorldReader)reader, blockpos)) {
            reader.func_180501_a(blockpos, blockstate, 2);
            flag = true;
        }
        return flag;
    }

    public static enum AlgaeTypes implements IStringSerializable
    {
        AMAZON_SWORD((Block)ModBlock.AMAZON_SWORD.get(), 4, (Boolean)ConfigFeatureControl.addAlgae.get(), 6, Biome.Category.SWAMP, Biome.Category.JUNGLE),
        EELGRASS((Block)ModBlock.EELGRASS.get(), 4, (Boolean)ConfigFeatureControl.addAlgae.get(), 6, Biome.Category.OCEAN);

        public Block type;
        public int rarity;
        public boolean enabled;
        public int size;
        public Biome.Category[] spawnBiomes;

        private AlgaeTypes(Block type, int rolls, boolean add, int size, Biome.Category ... biomes) {
            this.type = type;
            this.rarity = rolls;
            this.enabled = add;
            this.spawnBiomes = biomes;
            this.size = size;
        }

        public String func_176610_l() {
            return "why would you do this?";
        }

        public static Pair<Block, Integer> getAlgaeForPos(IWorld world, BlockPos pos) {
            Optional optional = world.func_242406_i(pos);
            if (Objects.equals(optional, Optional.of(Biomes.field_76776_l)) || Objects.equals(optional, Optional.of(Biomes.field_203620_Z))) {
                return null;
            }
            Biome biome = world.func_226691_t_(pos);
            ArrayList<AlgaeTypes> types = new ArrayList<AlgaeTypes>();
            for (AlgaeTypes type : AlgaeTypes.values()) {
                if (!type.enabled) continue;
                for (Biome.Category biomeTypes : type.spawnBiomes) {
                    if (biome.func_201856_r() != biomeTypes) continue;
                    for (int i = 0; i < type.rarity; ++i) {
                        types.add(type);
                    }
                }
            }
            if (!types.isEmpty()) {
                int i = new Random().nextInt(types.size());
                return new Pair((Object)((AlgaeTypes)((Object)types.get((int)i))).type, (Object)((AlgaeTypes)((Object)types.get((int)i))).size);
            }
            return null;
        }
    }
}

