/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import untamedwilds.UntamedWilds;
import untamedwilds.compat.CompatBridge;
import untamedwilds.config.ConfigFeatureControl;
import untamedwilds.config.ConfigMobControl;
import untamedwilds.world.FaunaHandler;
import untamedwilds.world.gen.feature.FeatureApexPredators;
import untamedwilds.world.gen.feature.FeatureCritterBurrow;
import untamedwilds.world.gen.feature.FeatureCritters;
import untamedwilds.world.gen.feature.FeatureDenseWater;
import untamedwilds.world.gen.feature.FeatureFloatingPlants;
import untamedwilds.world.gen.feature.FeatureOceanSessileSpawns;
import untamedwilds.world.gen.feature.FeatureOceanSwimming;
import untamedwilds.world.gen.feature.FeatureReedClusters;
import untamedwilds.world.gen.feature.FeatureSeaAnemone;
import untamedwilds.world.gen.feature.FeatureUndergroundFaunaLarge;
import untamedwilds.world.gen.feature.FeatureUnderwaterAlgae;
import untamedwilds.world.gen.feature.FeatureVegetation;
import untamedwilds.world.gen.treedecorator.TreeOrchidDecorator;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class UntamedWildsGenerator {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"untamedwilds");
    public static final Map<String, Float> biodiversity_levels = new HashMap<String, Float>();
    public static final DeferredRegister<TreeDecoratorType<?>> TREE_DECORATION = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TREE_DECORATOR_TYPES, (String)"untamedwilds");
    private static final RegistryObject<Feature<FeatureSpreadConfig>> SEA_ANEMONE = UntamedWildsGenerator.regFeature("sea_anemone", () -> new FeatureSeaAnemone((Codec<FeatureSpreadConfig>)FeatureSpreadConfig.field_242797_a));
    private static final RegistryObject<Feature<NoFeatureConfig>> REEDS = UntamedWildsGenerator.regFeature("reeds", () -> new FeatureReedClusters((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> ALGAE = UntamedWildsGenerator.regFeature("algae", () -> new FeatureUnderwaterAlgae((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<FeatureSpreadConfig>> VEGETATION = UntamedWildsGenerator.regFeature("vegetation", () -> new FeatureVegetation((Codec<FeatureSpreadConfig>)FeatureSpreadConfig.field_242797_a));
    private static final RegistryObject<Feature<NoFeatureConfig>> FLOATING_VEGETATION = UntamedWildsGenerator.regFeature("floating_vegetation", () -> new FeatureFloatingPlants((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<TreeDecoratorType<?>> TREE_ORCHID = TREE_DECORATION.register("orchid", () -> new TreeDecoratorType(TreeOrchidDecorator.CODEC));
    private static final RegistryObject<Feature<NoFeatureConfig>> UNDERGROUND = UntamedWildsGenerator.regFeature("underground", () -> new FeatureUndergroundFaunaLarge((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> APEX = UntamedWildsGenerator.regFeature("apex_predator", () -> new FeatureApexPredators((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> CRITTERS = UntamedWildsGenerator.regFeature("critter", () -> new FeatureCritters((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> SESSILE = UntamedWildsGenerator.regFeature("sessile", () -> new FeatureOceanSessileSpawns((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> OCEAN = UntamedWildsGenerator.regFeature("ocean_rare", () -> new FeatureOceanSwimming((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> DENSE_WATER = UntamedWildsGenerator.regFeature("dense_water", () -> new FeatureDenseWater((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    private static final RegistryObject<Feature<NoFeatureConfig>> CRITTER_BURROW = UntamedWildsGenerator.regFeature("burrow", () -> new FeatureCritterBurrow((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));

    private static <B extends Feature<?>> RegistryObject<B> regFeature(String name, Supplier<? extends B> supplier) {
        return FEATURES.register(name, supplier);
    }

    @SubscribeEvent
    public static void onBiomesLoad(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.OCEAN) {
            if (!FaunaHandler.getSpawnableList(FaunaHandler.animalType.SESSILE).isEmpty()) {
                UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)SESSILE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Integer)ConfigFeatureControl.freqSessile.get());
            }
            if (!FaunaHandler.getSpawnableList(FaunaHandler.animalType.LARGE_OCEAN).isEmpty()) {
                UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)OCEAN.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Integer)ConfigFeatureControl.freqOcean.get());
            }
            if (!event.getName().toString().equals("minecraft:frozen_ocean") && !event.getName().toString().equals("minecraft:deep_frozen_ocean") && ((Boolean)ConfigFeatureControl.addAnemones.get()).booleanValue()) {
                UntamedWildsGenerator.registerFeature(event, GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)((Feature)SEA_ANEMONE.get()).func_225566_b_((IFeatureConfig)new FeatureSpreadConfig(4)).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(16), ((Feature)SEA_ANEMONE.get()).getRegistryName());
            }
        }
        if (event.getCategory() == Biome.Category.JUNGLE) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)FLOATING_VEGETATION.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_243995_f), 1, (Boolean)ConfigFeatureControl.addAlgae.get());
        }
        if (!(event.getCategory() != Biome.Category.RIVER && event.getCategory() != Biome.Category.JUNGLE && event.getCategory() != Biome.Category.SWAMP || ((List)ConfigFeatureControl.reedBlacklist.get()).contains(event.getName().toString()))) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)REEDS.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_243995_f), (Integer)ConfigFeatureControl.freqReeds.get(), (Boolean)ConfigFeatureControl.addReeds.get());
        }
        if (!((List)ConfigFeatureControl.algaeBlacklist.get()).contains(event.getName().toString())) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ALGAE.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244003_n), (Integer)ConfigFeatureControl.freqAlgae.get(), (Boolean)ConfigFeatureControl.addAlgae.get());
        }
        if (!((List)ConfigFeatureControl.floraBlacklist.get()).contains(event.getName().toString())) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)VEGETATION.get()).func_225566_b_((IFeatureConfig)new FeatureSpreadConfig(4)).func_227228_a_(Features.Placements.field_243995_f), (Integer)ConfigFeatureControl.freqFlora.get(), (Boolean)ConfigFeatureControl.addFlora.get());
        }
        if (!FaunaHandler.getSpawnableList(FaunaHandler.animalType.DENSE_WATER).isEmpty()) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)DENSE_WATER.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Integer)ConfigFeatureControl.freqWater.get());
        }
        if (!FaunaHandler.getSpawnableList(FaunaHandler.animalType.CRITTER).isEmpty()) {
            if (((Boolean)ConfigFeatureControl.addBurrows.get()).booleanValue()) {
                UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)CRITTER_BURROW.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Integer)ConfigFeatureControl.freqCritter.get());
            } else {
                UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)CRITTERS.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Integer)ConfigFeatureControl.freqCritter.get());
            }
        }
        if (!FaunaHandler.getSpawnableList(FaunaHandler.animalType.APEX_PRED).isEmpty()) {
            UntamedWildsGenerator.registerFeatureWithFreq(event, GenerationStage.Decoration.TOP_LAYER_MODIFICATION, ((Feature)APEX.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e), (Integer)ConfigFeatureControl.freqApex.get());
        }
        if ((Double)ConfigFeatureControl.probUnderground.get() != 0.0 && ((Boolean)ConfigMobControl.masterSpawner.get()).booleanValue()) {
            float prob = ((Double)ConfigFeatureControl.probUnderground.get()).floatValue() / (float)(CompatBridge.betterCaves || CompatBridge.cavesAndCliffs ? 3 : 1);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, ((Feature)UNDERGROUND.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_((ConfiguredPlacement)Placement.field_215039_y.func_227446_a_((IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.AIR, prob)).func_242729_a(2)));
        }
    }

    private static void registerFeatureWithFreq(BiomeLoadingEvent event, GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature, int freq) {
        UntamedWildsGenerator.registerFeatureWithFreq(event, decoration, feature, freq, (Boolean)ConfigMobControl.masterSpawner.get());
    }

    private static void registerFeatureWithFreq(BiomeLoadingEvent event, GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature, int freq, boolean enable) {
        if (freq > 0 && enable) {
            UntamedWildsGenerator.registerFeature(event, decoration, (ConfiguredFeature)feature.func_242729_a(freq), feature.field_222737_a.getRegistryName());
        }
    }

    private static void registerFeature(BiomeLoadingEvent event, GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> feature, ResourceLocation name) {
        event.getGeneration().func_242513_a(decoration, feature);
    }

    public static void readBioDiversityLevels() {
        try (InputStream inputstream = LanguageMap.class.getResourceAsStream("/data/untamedwilds/tags/biodiversity_levels.json");){
            JsonObject jsonobject = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(inputstream, StandardCharsets.UTF_8), JsonObject.class);
            for (Map.Entry entry : jsonobject.entrySet()) {
                biodiversity_levels.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
            }
        }
        catch (JsonParseException | IOException ioexception) {
            UntamedWilds.LOGGER.error("Couldn't read data from /data/untamedwilds/tags/biodiversity_levels.json", ioexception);
        }
    }

    public static float getBioDiversityLevel(ResourceLocation biome) {
        String key = biome.toString();
        if (biodiversity_levels.containsKey(key)) {
            return biodiversity_levels.get(key).floatValue();
        }
        return 0.6f;
    }
}

