/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.ForgeHooks;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.EntityUtils;
import untamedwilds.world.UntamedWildsGenerator;

public class FaunaSpawn {
    private static boolean isSpawnableSpace(IBlockReader worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn, EntityType<?> entityTypeIn) {
        if (state.func_235785_r_(worldIn, pos)) {
            return false;
        }
        if (state.func_185897_m()) {
            return false;
        }
        if (!fluidStateIn.func_206888_e()) {
            return false;
        }
        if (state.func_235714_a_((ITag)BlockTags.field_232884_az_)) {
            return false;
        }
        return !entityTypeIn.func_233597_a_(state);
    }

    private static boolean canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        if (placeType == EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS) {
            return true;
        }
        if (entityTypeIn != null && worldIn.func_175723_af().func_177746_a(pos)) {
            return FaunaSpawn.canSpawnAtBody(placeType, worldIn, pos, entityTypeIn);
        }
        return false;
    }

    private static boolean canSpawnAtBody(EntitySpawnPlacementRegistry.PlacementType placeType, IWorldReader worldIn, BlockPos pos, @Nullable EntityType<?> entityTypeIn) {
        BlockState blockstate = worldIn.func_180495_p(pos);
        FluidState ifluidstate = worldIn.func_204610_c(pos);
        BlockPos blockpos1 = pos.func_177977_b();
        switch (placeType) {
            case IN_WATER: {
                return ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case IN_LAVA: {
                return ifluidstate.func_206884_a((ITag)FluidTags.field_206960_b);
            }
        }
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.canCreatureSpawn(worldIn, blockpos1, placeType, entityTypeIn)) {
            return false;
        }
        return FaunaSpawn.isSpawnableSpace((IBlockReader)worldIn, pos, blockstate, ifluidstate, entityTypeIn);
    }

    public static boolean performWorldGenSpawning(EntityType<?> entityType, EntitySpawnPlacementRegistry.PlacementType spawnType, @Nullable Heightmap.Type heightMap, ISeedReader worldIn, BlockPos pos, Random rand, int groupSize) {
        if (entityType != null && !worldIn.func_201670_d()) {
            int i = pos.func_177958_n() + rand.nextInt(16);
            int j = pos.func_177952_p() + rand.nextInt(16);
            if (heightMap != null) {
                pos.func_177982_a(i, 0, j);
                pos = worldIn.func_205770_a(heightMap, pos);
            }
            if (rand.nextFloat() < UntamedWildsGenerator.getBioDiversityLevel(Objects.requireNonNull(worldIn.func_226691_t_(pos).getRegistryName()))) {
                int k = 1;
                int species = -1;
                block2: for (int packSize = 0; packSize < k; ++packSize) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    if (packSize != 0) {
                        x += rand.nextInt(6);
                        z += rand.nextInt(6);
                    }
                    for (int attempt = 0; attempt < 4; ++attempt) {
                        MobEntity mobentity;
                        Entity entity;
                        double d1;
                        if (attempt != 0) {
                            if (attempt == 1) {
                                ++y;
                            }
                            x += rand.nextInt(2);
                            z += rand.nextInt(2);
                        }
                        BlockPos blockpos = new BlockPos(x, y, z);
                        if (!entityType.func_200720_b() || !FaunaSpawn.canCreatureTypeSpawnAtLocation(spawnType, (IWorldReader)worldIn, blockpos, entityType)) continue;
                        float f = entityType.func_220333_h();
                        double d0 = MathHelper.func_151237_a((double)x, (double)((double)blockpos.func_177958_n() + (double)f), (double)((double)blockpos.func_177958_n() + 16.0 - (double)f));
                        if (!worldIn.func_226664_a_(entityType.func_220328_a(d0, (double)y, d1 = MathHelper.func_151237_a((double)z, (double)((double)blockpos.func_177952_p() + (double)f), (double)((double)blockpos.func_177952_p() + 16.0 - (double)f)))) || !EntitySpawnPlacementRegistry.func_223515_a(entityType, (IServerWorld)worldIn, (SpawnReason)SpawnReason.CHUNK_GENERATION, (BlockPos)blockpos, (Random)worldIn.func_201674_k())) continue;
                        try {
                            entity = entityType.func_200721_a((World)worldIn.func_201672_e());
                        }
                        catch (Exception exception) {
                            UntamedWilds.LOGGER.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        assert (entity != null);
                        entity.func_70012_b((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), rand.nextFloat() * 360.0f, 0.0f);
                        if (!(entity instanceof MobEntity) || ForgeHooks.canEntitySpawn((MobEntity)(mobentity = (MobEntity)entity), (IWorld)worldIn, (double)d0, (double)blockpos.func_177956_o(), (double)d1, null, (SpawnReason)SpawnReason.CHUNK_GENERATION) == -1 || !mobentity.func_213380_a((IWorld)worldIn, SpawnReason.CHUNK_GENERATION) || !mobentity.func_205019_a((IWorldReader)worldIn)) continue;
                        mobentity.func_213386_a((IServerWorld)worldIn, worldIn.func_175649_E(mobentity.func_233580_cy_()), SpawnReason.CHUNK_GENERATION, null, null);
                        if (mobentity instanceof ComplexMob && mobentity.func_70089_S()) {
                            if (mobentity instanceof ISpecies) {
                                if (species == -1) {
                                    species = ((ComplexMob)mobentity).getVariant();
                                    if (species != 99) {
                                        k = EntityUtils.getPackSize(entityType, species);
                                    }
                                } else {
                                    ((ComplexMob)mobentity).setVariant(species);
                                    ((ComplexMob)mobentity).chooseSkinForSpecies((ComplexMob)mobentity, false);
                                    if (mobentity instanceof INeedsPostUpdate) {
                                        ((INeedsPostUpdate)mobentity).updateAttributes();
                                    }
                                }
                            }
                            if (((ComplexMob)mobentity).getVariant() == 99 || !ComplexMob.ENTITY_DATA_HASH.containsKey(entityType)) {
                                mobentity.func_70106_y();
                                return false;
                            }
                        }
                        if (!mobentity.func_70089_S()) continue block2;
                        worldIn.func_242417_l((Entity)mobentity);
                        continue block2;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

