/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.world;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.WeightedRandom;

public abstract class FaunaHandler {
    private static final List<SpawnListEntry> spawnCritter = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnUndergroundLarge = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnLargePrey = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnDenseWater = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnOcean = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnSessile = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnSmallPred = Lists.newArrayList();
    private static final List<SpawnListEntry> spawnApexPred = Lists.newArrayList();

    public FaunaHandler() {
        spawnLargePrey.add(new SpawnListEntry(EntityType.field_200737_ac, 12, 4));
    }

    public static List<SpawnListEntry> getSpawnableList(animalType type) {
        switch (type) {
            default: {
                return spawnCritter;
            }
            case SESSILE: {
                return spawnSessile;
            }
            case DENSE_WATER: {
                return spawnDenseWater;
            }
            case LARGE_OCEAN: {
                return spawnOcean;
            }
            case LARGE_HERB: {
                return spawnLargePrey;
            }
            case SMALL_PRED: {
                return spawnSmallPred;
            }
            case APEX_PRED: {
                return spawnApexPred;
            }
            case LARGE_UNDERGROUND: 
        }
        return spawnUndergroundLarge;
    }

    public static enum animalType {
        CRITTER,
        SESSILE,
        DENSE_WATER,
        LARGE_OCEAN,
        LARGE_HERB,
        SMALL_PRED,
        LARGE_UNDERGROUND,
        APEX_PRED;

    }

    public static class SpawnListEntry
    extends WeightedRandom.Item {
        public EntityType<?> entityType;
        public int field_76292_a;
        public int groupCount;

        public SpawnListEntry(EntityType<?> entityTypeIn, int weight, int groupCount) {
            super(weight);
            this.entityType = entityTypeIn;
            this.field_76292_a = weight;
            this.groupCount = groupCount;
        }

        public String toString() {
            return EntityType.func_200718_a(this.entityType) + "*(1-" + this.groupCount + "):" + this.field_76292_a;
        }
    }
}

