/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.EntityDataHolder;

public abstract class EntityUtils {
    public static void destroyBoat(World worldIn, LivingEntity entityIn) {
        if (entityIn.func_184187_bx() != null && entityIn.func_184187_bx() instanceof BoatEntity) {
            BoatEntity boat = (BoatEntity)entityIn.func_184187_bx();
            boat.func_70106_y();
            if (worldIn.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
                for (int j = 0; j < 3; ++j) {
                    boat.func_199703_a((IItemProvider)boat.func_184453_r().func_195933_b());
                }
                for (int k = 0; k < 2; ++k) {
                    boat.func_199703_a((IItemProvider)Items.field_151055_y);
                }
            }
        }
    }

    public static <T extends IParticleData> void spawnParticlesOnEntity(World worldIn, LivingEntity entityIn, T particle, int count, int iter) {
        if (worldIn.field_72995_K) {
            return;
        }
        for (int i = 0; i < iter; ++i) {
            ((ServerWorld)worldIn).func_195598_a(particle, entityIn.func_226277_ct_(), entityIn.func_226278_cu_() + (double)entityIn.func_213302_cg() / 1.5, entityIn.func_226281_cx_(), count, (double)(entityIn.func_213311_cf() / 4.0f), (double)(entityIn.func_213302_cg() / 4.0f), (double)(entityIn.func_213311_cf() / 4.0f), 0.05);
        }
    }

    public static int getPackSize(EntityType<?> type, int variant) {
        return ComplexMob.getEntityData(type).getGroupCount(variant);
    }

    public static EntityType<?> getEntityTypeFromTag(CompoundNBT nbt, @Nullable EntityType<?> alt) {
        CompoundNBT entityNBT;
        if (nbt != null && nbt.func_150297_b("EntityTag", 10) && (entityNBT = nbt.func_74775_l("EntityTag")).func_150297_b("id", 8)) {
            return EntityType.func_220327_a((String)entityNBT.func_74779_i("id")).orElse(alt);
        }
        return alt;
    }

    public static void buildTooltipData(ItemStack stack, List<ITextComponent> tooltip, EntityType<?> entity, String path) {
        CompoundNBT compound;
        if (stack.func_77978_p() != null && (compound = stack.func_179543_a("EntityTag")) != null) {
            String gender = compound.func_74764_b("Gender") ? new TranslationTextComponent("mobspawn.tooltip." + (compound.func_74762_e("Gender") == 0 ? "male" : "female")).getString() + " " : "";
            String type = path.isEmpty() ? new TranslationTextComponent(entity.func_210760_d()).getString() : new TranslationTextComponent(entity.func_210760_d() + "_" + path).getString();
            if (stack.func_77978_p().func_74775_l("EntityTag").func_74764_b("CustomName")) {
                String customName = stack.func_77978_p().func_74775_l("EntityTag").func_74779_i("CustomName");
                tooltip.add((ITextComponent)new StringTextComponent(customName.substring(9, customName.length() - 2) + " (" + gender + type + ")").func_240699_a_(TextFormatting.GRAY));
            } else {
                tooltip.add((ITextComponent)new StringTextComponent(gender + type).func_240699_a_(TextFormatting.GRAY));
            }
        }
        if (((Boolean)ConfigGamerules.scientificNames.get()).booleanValue()) {
            String scipath = path.isEmpty() ? "" : "_" + path;
            TranslationTextComponent tooltipText = new TranslationTextComponent(entity.func_210760_d() + scipath + ".sciname");
            if (!tooltipText.getString().contains(".")) {
                tooltip.add((ITextComponent)tooltipText.func_240701_a_(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY}));
            }
        }
    }

    public static void createMobFromItem(ServerWorld worldIn, ItemStack itemstack, EntityType<?> entity, @Nullable int species, BlockPos spawnPos, @Nullable PlayerEntity player, boolean offset) {
        if (itemstack.func_77978_p() != null) {
            if (itemstack.func_77978_p().func_74764_b("EntityTag")) {
                Entity spawn;
                if (itemstack.func_179543_a("EntityTag").func_74764_b("UUID") && worldIn.func_217461_a(itemstack.func_179543_a("EntityTag").func_186857_a("UUID")) != null) {
                    itemstack.func_179543_a("EntityTag").func_186854_a("UUID", MathHelper.func_180182_a((Random)worldIn.field_73012_v));
                }
                if ((spawn = entity.func_220331_a(worldIn, itemstack, player, spawnPos, SpawnReason.BUCKET, true, offset)) != null && itemstack.func_82837_s()) {
                    spawn.func_200203_b(itemstack.func_200301_q());
                }
            }
        } else {
            Entity spawn = entity.func_220342_a(worldIn, null, null, player, spawnPos, SpawnReason.SPAWN_EGG, true, offset);
            if (spawn instanceof ComplexMob) {
                ((ComplexMob)spawn).setVariant(species);
                ((ComplexMob)spawn).chooseSkinForSpecies((ComplexMob)spawn, true);
            }
            if (spawn != null && itemstack.func_82837_s()) {
                spawn.func_200203_b(itemstack.func_200301_q());
            }
        }
    }

    public static void dropEggs(ComplexMob entity, String item_name, int number) {
        CompoundNBT baseTag = new CompoundNBT();
        ItemStack item = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:" + item_name.toLowerCase())));
        baseTag.func_74768_a("variant", entity.getVariant());
        baseTag.func_74768_a("custom_model_data", entity.getVariant());
        item.func_77982_d(baseTag);
        ItemEntity entityitem = entity.func_70099_a(item, 0.2f);
        if (entityitem != null) {
            entityitem.func_92059_d().func_190920_e(1 + entity.func_70681_au().nextInt(number - 1));
        }
    }

    public static void turnEntityIntoItem(LivingEntity entity, String item_name) {
        if (((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() || ((MobEntity)entity).func_70638_az() == null) {
            ItemEntity entityitem = entity.func_70099_a(new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:" + item_name.toLowerCase()))), 0.2f);
            Random rand = entity.func_70681_au();
            if (entityitem != null) {
                entityitem.func_213293_j((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f));
                entityitem.func_92059_d().func_77982_d(EntityUtils.writeEntityToNBT(entity, false, true));
                if (entity.func_145818_k_()) {
                    entityitem.func_92059_d().func_200302_a(entity.func_200201_e());
                }
                entity.func_70106_y();
            }
        }
    }

    public static void mutateEntityIntoItem(LivingEntity entity, PlayerEntity player, Hand hand, String item_name, ItemStack itemstack) {
        if (((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() || ((MobEntity)entity).func_70638_az() == null) {
            entity.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            itemstack.func_190918_g(1);
            ItemStack newitem = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:" + item_name.toLowerCase())));
            newitem.func_77982_d(EntityUtils.writeEntityToNBT(entity, false, true));
            if (entity.func_145818_k_()) {
                newitem.func_200302_a(entity.func_200201_e());
            }
            if (!entity.field_70170_p.field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, newitem);
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, newitem);
            } else if (!player.field_71071_by.func_70441_a(newitem)) {
                player.func_71019_a(newitem, false);
            }
            entity.func_70106_y();
        }
    }

    public static List<ItemStack> getItemFromLootTable(ResourceLocation lootTableIn, World worldIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)worldIn);
        if (worldIn.func_73046_m() != null) {
            return worldIn.func_73046_m().func_200249_aQ().func_186521_a(lootTableIn).func_216113_a(lootcontext$builder.func_216022_a(new LootParameterSet.Builder().func_216270_a()));
        }
        return Lists.newArrayList();
    }

    public static CompoundNBT writeEntityToNBT(LivingEntity entity) {
        return EntityUtils.writeEntityToNBT(entity, false);
    }

    public static CompoundNBT writeEntityToNBT(LivingEntity entity, boolean keepHomeData) {
        return EntityUtils.writeEntityToNBT(entity, keepHomeData, false);
    }

    public static CompoundNBT writeEntityToNBT(LivingEntity entity, boolean keepHomeData, boolean attachModelData) {
        CompoundNBT baseTag = new CompoundNBT();
        CompoundNBT entityTag = new CompoundNBT();
        entity.func_184198_c(entityTag);
        entityTag.func_82580_o("Pos");
        entityTag.func_82580_o("Motion");
        if (entityTag.func_74764_b("BoundingBox")) {
            entityTag.func_82580_o("BoundingBox");
        }
        if (entity instanceof ISpecies && !keepHomeData) {
            entityTag.func_82580_o("HomePosX");
            entityTag.func_82580_o("HomePosY");
            entityTag.func_82580_o("HomePosZ");
        }
        if (attachModelData && entity instanceof ComplexMob) {
            baseTag.func_74768_a("CustomModelData", ((ComplexMob)entity).getVariant());
        }
        baseTag.func_218657_a("EntityTag", (INBT)entityTag);
        return baseTag;
    }

    public static boolean hasFullHealth(LivingEntity entityIn) {
        return entityIn.func_110143_aJ() >= entityIn.func_110138_aP();
    }

    public static Pair<Integer, Integer> buildSkinArrays(String name, String species, EntityDataHolder dataIn, int variant, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> common_list, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> rare_list) {
        return EntityUtils.buildSkinArrays(name, species, dataIn.getSkins(variant), variant, common_list, rare_list);
    }

    public static Pair<Integer, Integer> buildSkinArrays(String name, String species, int skins, int variant, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> common_list, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> rare_list) {
        String full_path;
        int i;
        String path = "textures/entity/" + name + "/" + species;
        if (!common_list.containsKey(name)) {
            common_list.put(name, new HashMap());
        }
        if (!rare_list.containsKey(name)) {
            rare_list.put(name, new HashMap());
        }
        int value = skins;
        Pair values = new Pair((Object)(value / 10 - 1), (Object)(value % 10 - 1));
        common_list.get(name).put(variant, new ArrayList());
        if ((Integer)values.getFirst() >= 1) {
            for (i = 0; i <= (Integer)values.getFirst(); ++i) {
                full_path = String.format(path + "_%d.png", i + 1);
                common_list.get(name).get(variant).add(new ResourceLocation("untamedwilds", full_path));
            }
        } else {
            common_list.get(name).get(variant).add(new ResourceLocation("untamedwilds", path + ".png"));
        }
        if ((Integer)values.getSecond() >= 0) {
            rare_list.get(name).put(variant, new ArrayList());
            for (i = 0; i <= (Integer)values.getSecond(); ++i) {
                full_path = String.format(path + "_%dr.png", i + 1);
                rare_list.get(name).get(variant).add(new ResourceLocation("untamedwilds", full_path));
            }
        }
        return values;
    }

    @Deprecated
    public static int populateSkinArray(String path, String suffix, int variant, HashMap<Integer, ArrayList<ResourceLocation>> list, boolean addDefault) {
        list.put(variant, new ArrayList());
        for (int i = 0; i < 99; ++i) {
            int k = i;
            try {
                if (!suffix.matches("[^a-z0-9/._:-]")) {
                    String full_path = String.format(path + suffix, i + 1);
                    Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation("untamedwilds", full_path));
                    list.get(variant).add(new ResourceLocation("untamedwilds", full_path));
                    continue;
                }
                UntamedWilds.LOGGER.error("Invalid character in " + suffix + ", terminating Skin registry");
                break;
            }
            catch (Exception e) {
                if (k == 0 && addDefault) {
                    list.get(variant).add(new ResourceLocation("untamedwilds", path + ".png"));
                    ++k;
                }
                if (list.get(variant).isEmpty()) {
                    list.remove(variant);
                }
                return k;
            }
        }
        return 0;
    }

    public static String getVariantName(EntityType<?> typeIn, int variantIn) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.ENTITY_DATA_HASH.get(typeIn).getName(variantIn);
        }
        if (ComplexMob.CLIENT_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.CLIENT_DATA_HASH.get(typeIn).getSpeciesName(variantIn);
        }
        return "";
    }

    public static int getNumberOfSpecies(EntityType<?> typeIn) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.ENTITY_DATA_HASH.get(typeIn).getSpeciesData().size();
        }
        if (ComplexMob.CLIENT_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.CLIENT_DATA_HASH.get(typeIn).getNumberOfSpecies();
        }
        UntamedWilds.LOGGER.warn("There's no species provided for the EntityType");
        return 0;
    }

    public static SoundEvent getSound(EntityType<?> typeIn, int variantIn, String sound_type) {
        return EntityUtils.getSound(typeIn, variantIn, sound_type, null);
    }

    public static SoundEvent getSound(EntityType<?> typeIn, int variantIn, String sound_type, @Nullable SoundEvent fallback) {
        SoundEvent location;
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(typeIn) && (location = ComplexMob.ENTITY_DATA_HASH.get(typeIn).getSounds(variantIn, sound_type)) != null) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(location.field_187506_b);
        }
        return fallback;
    }

    public static int getClampedNumberOfSpecies(int i, EntityType<?> typeIn) {
        int size = Math.max(0, EntityUtils.getNumberOfSpecies(typeIn) - 1);
        if (i > size) {
            UntamedWilds.LOGGER.warn("Correcting wrong Variant value of " + i + " to " + size);
        }
        return MathHelper.func_76125_a((int)i, (int)0, (int)size);
    }

    public static ResourceLocation getSkinFromEntity(ComplexMob entityIn) {
        if (entityIn.func_200600_R().getRegistryName() != null) {
            String name = entityIn.func_200600_R().getRegistryName().func_110623_a();
            if (entityIn.getSkin() > 99 && ComplexMob.TEXTURES_RARE.get(name).containsKey(entityIn.getVariant())) {
                return ComplexMob.TEXTURES_RARE.get(name).get(entityIn.getVariant()).get(Math.min(entityIn.getSkin() - 100, ComplexMob.TEXTURES_RARE.get(name).get(entityIn.getVariant()).size() - 1));
            }
            return ComplexMob.TEXTURES_COMMON.get(name).get(entityIn.getVariant()).get(Math.min(entityIn.getSkin(), ComplexMob.TEXTURES_COMMON.get(name).get(entityIn.getVariant()).size() - 1));
        }
        return ResourceLocation.func_208304_a((String)"");
    }

    public static void consumeItemStack(TameableEntity entityIn, ItemStack itemstack) {
        block8: {
            block7: {
                if (!itemstack.func_222117_E()) break block7;
                Food itemFood = itemstack.func_77973_b().func_219967_s();
                if (itemFood == null) break block8;
                entityIn.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                if (entityIn instanceof ComplexMobTerrestrial) {
                    ((ComplexMobTerrestrial)entityIn).addHunger(itemFood.func_221466_a() * 10);
                } else {
                    entityIn.func_70691_i((float)itemFood.func_221466_a());
                }
                for (Pair pair : itemFood.func_221464_f()) {
                    if (pair.getFirst() == null || !(entityIn.field_70170_p.field_73012_v.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                    entityIn.func_195064_c(new EffectInstance((EffectInstance)pair.getFirst()));
                }
                break block8;
            }
            if (itemstack.func_77962_s()) {
                entityIn.func_184185_a(SoundEvents.field_187664_bz, 1.0f, 1.0f);
                if (entityIn instanceof ComplexMobTerrestrial) {
                    ((ComplexMobTerrestrial)entityIn).addHunger(10);
                }
                for (EffectInstance effectinstance : PotionUtils.func_185189_a((ItemStack)itemstack)) {
                    if (effectinstance.func_188419_a().func_76403_b()) {
                        effectinstance.func_188419_a().func_180793_a((Entity)entityIn.func_70902_q(), (Entity)entityIn.func_70902_q(), (LivingEntity)entityIn, effectinstance.func_76458_c(), 1.0);
                        continue;
                    }
                    entityIn.func_195064_c(new EffectInstance(effectinstance));
                }
            }
        }
    }

    public static Vector3d getOvershootPath(Entity entityIn, Entity targetIn, double overshoot) {
        double x = targetIn.func_226277_ct_() - entityIn.func_226277_ct_();
        double z = targetIn.func_226281_cx_() - entityIn.func_226281_cx_();
        float angle = (float)Math.atan2(z, x);
        double dist = MathHelper.func_76133_a((double)(Math.pow(x, 2.0) + Math.pow(z, 2.0)));
        double add_x = (double)MathHelper.func_76134_b((float)angle) * (dist + overshoot);
        double add_z = (double)MathHelper.func_76126_a((float)angle) * (dist + overshoot);
        return new Vector3d(entityIn.func_226277_ct_() + add_x, targetIn.func_226278_cu_(), entityIn.func_226281_cx_() + add_z);
    }

    public static boolean isInvalidPartner(ComplexMob entityIn, ComplexMob partnerIn, boolean isHermaphrodite) {
        return (Boolean)ConfigGamerules.genderedBreeding.get() != false && (partnerIn.getGender() == entityIn.getGender() || isHermaphrodite) || partnerIn.getVariant() != entityIn.getVariant() || partnerIn.func_70874_b() != 0;
    }
}

