/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.util.SpeciesDataHolder;

public class EntityDataHolder {
    public static final Codec<EntityDataHolder> CODEC = RecordCodecBuilder.create(p_237051_0_ -> p_237051_0_.group((App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(p_237056_0_ -> p_237056_0_.name), (App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(1.0f)).forGetter(p_237055_0_ -> Float.valueOf(p_237055_0_.modelScale)), (App)Codec.INT.fieldOf("rarity").orElse((Object)0).forGetter(p_237054_0_ -> p_237054_0_.rarity), (App)Codec.FLOAT.fieldOf("attack").orElse((Object)Float.valueOf(-1.0f)).forGetter(p_237054_0_ -> Float.valueOf(p_237054_0_.attack)), (App)Codec.FLOAT.fieldOf("health").orElse((Object)Float.valueOf(-1.0f)).forGetter(p_237054_0_ -> Float.valueOf(p_237054_0_.health)), (App)ComplexMobTerrestrial.ActivityType.CODEC.fieldOf("activityType").orElse((Object)ComplexMobTerrestrial.ActivityType.INSOMNIAC).forGetter(p_237052_0_ -> p_237052_0_.activityType), (App)Codec.STRING.fieldOf("favourite_food").orElse((Object)"").forGetter(p_237052_0_ -> p_237052_0_.favouriteFood_input), (App)Codec.INT.fieldOf("growing_time").orElse((Object)1).forGetter(p_237054_0_ -> p_237054_0_.growing_time), (App)Codec.INT.fieldOf("offspring").orElse((Object)1).forGetter(p_237054_0_ -> p_237054_0_.offspring), (App)Codec.STRING.fieldOf("breeding_season").orElse((Object)"ANY").forGetter(p_237054_0_ -> p_237054_0_.breeding_season), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SoundEvent.field_232678_a_).fieldOf("sounds").orElse(Collections.emptyMap()).forGetter(p_237052_0_ -> p_237052_0_.sounds), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("flags").orElse(Collections.emptyMap()).forGetter(p_237054_0_ -> p_237054_0_.flags), (App)SpeciesDataHolder.CODEC.listOf().fieldOf("species").orElse(new ArrayList()).forGetter(p_237052_0_ -> p_237052_0_.speciesData)).apply((Applicative)p_237051_0_, EntityDataHolder::new));
    private final String name;
    private final float modelScale;
    private final int rarity;
    private final float attack;
    private final float health;
    private final ComplexMobTerrestrial.ActivityType activityType;
    private final String favouriteFood_input;
    private final ItemStack favouriteFood;
    private final int growing_time;
    private final int offspring;
    private final String breeding_season;
    public final Map<String, SoundEvent> sounds;
    private final Map<String, Integer> flags;
    private final List<SpeciesDataHolder> speciesData;

    public EntityDataHolder(String p_i232114_1_, float p_i232114_2_, int p_i232114_3_, float attack, float health, ComplexMobTerrestrial.ActivityType activityType, String favouriteFood, int growing_time, int offspring, String breeding, Map<String, SoundEvent> sounds, Map<String, Integer> flags, List<SpeciesDataHolder> speciesData) {
        this.name = p_i232114_1_;
        this.modelScale = p_i232114_2_;
        this.rarity = p_i232114_3_;
        this.attack = attack;
        this.health = health;
        this.activityType = activityType;
        this.favouriteFood_input = favouriteFood;
        this.favouriteFood = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)this.favouriteFood_input)));
        this.growing_time = growing_time;
        this.offspring = offspring;
        this.breeding_season = breeding;
        this.sounds = sounds;
        this.flags = flags;
        this.speciesData = speciesData;
    }

    public String getString() {
        return this.name + ": Scale: " + this.modelScale + " Rarity: " + this.rarity + " Attack: " + this.attack + " Health: " + this.health + " Ambient Sound: " + this.sounds;
    }

    public void printSpeciesData() {
        for (SpeciesDataHolder speciesDatum : this.speciesData) {
            UntamedWilds.LOGGER.info(speciesDatum.getString());
        }
    }

    public String getName(int i) {
        if (Objects.equals(this.speciesData.get(i).getName(), "")) {
            return this.name;
        }
        return this.speciesData.get(i).getName();
    }

    public float getScale(int i) {
        if (this.speciesData.get(i).getModelScale().floatValue() < 0.0f) {
            return this.modelScale;
        }
        return this.speciesData.get(i).getModelScale().floatValue();
    }

    public int getRarity(int i) {
        if (this.speciesData.get(i).getRarity() < 0) {
            return this.rarity;
        }
        return this.speciesData.get(i).getRarity();
    }

    public float getAttack(int i) {
        if (this.speciesData.get(i).getAttack().floatValue() < 0.0f) {
            return this.modelScale;
        }
        return this.speciesData.get(i).getAttack().floatValue();
    }

    public float getHealth(int i) {
        if (this.speciesData.get(i).getHealth().floatValue() < 0.0f) {
            return this.modelScale;
        }
        return this.speciesData.get(i).getHealth().floatValue();
    }

    public ComplexMobTerrestrial.ActivityType getActivityType(int i) {
        if (this.speciesData.get(i).getActivityType() == ComplexMobTerrestrial.ActivityType.INSOMNIAC) {
            return this.activityType;
        }
        return this.speciesData.get(i).getActivityType();
    }

    public ItemStack getFavouriteFood(int i) {
        if (this.speciesData.get(i).getFavouriteFood().equals("")) {
            return this.favouriteFood;
        }
        return this.speciesData.get(i).getFavouriteFood();
    }

    public int getGrowingTime(int i) {
        if (this.speciesData.get(i).getGrowingTime() < 0) {
            return this.growing_time;
        }
        return this.speciesData.get(i).getGrowingTime();
    }

    public int getOffspring(int i) {
        if (this.speciesData.get(i).getOffspring() < 0) {
            return this.offspring;
        }
        return this.speciesData.get(i).getOffspring();
    }

    public Integer getSkins(int i) {
        return this.speciesData.get(i).getSkins();
    }

    public String getBreedingSeason(int i) {
        if (this.speciesData.get(i).getBreedingSeason().equals("NONE")) {
            return this.breeding_season;
        }
        return this.speciesData.get(i).getBreedingSeason();
    }

    @Nullable
    public SoundEvent getSoundsWithAlt(int i, String sound_id, SoundEvent alt_sound) {
        SoundEvent event = this.getSounds(i, sound_id);
        if (event == null) {
            return alt_sound;
        }
        return event;
    }

    @Nullable
    public SoundEvent getSounds(int i, String sound_id) {
        if (!this.speciesData.get(i).getSounds().isEmpty() && this.speciesData.get(i).getSounds().get(sound_id) != null) {
            return this.speciesData.get(i).getSounds().get(sound_id);
        }
        return this.sounds.get(sound_id);
    }

    public Map<String, SoundEvent> getBaseSounds() {
        return this.sounds;
    }

    public Integer getGroupCount(int i) {
        if (!this.speciesData.get(i).getFlags().isEmpty() && this.speciesData.get(i).getFlags().get("groupCount") != null) {
            return this.speciesData.get(i).getFlags().get("groupCount");
        }
        return 1;
    }

    @Nullable
    public int getFlags(int i, String flag) {
        if (!this.speciesData.get(i).getFlags().isEmpty() && this.speciesData.get(i).getFlags().get(flag) != null) {
            return this.speciesData.get(i).getFlags().get(flag);
        }
        if (!this.flags.containsKey(flag)) {
            UntamedWilds.LOGGER.error("Couldn't find " + flag + " flag in ENTITY_DATA");
            return 0;
        }
        return this.flags.get(flag);
    }

    public List<SpeciesDataHolder> getSpeciesData() {
        return this.speciesData;
    }
}

